rem --------------------------------------------------------------------------
rem Note: If running JIRA as a Service, settings in this file have no
rem effect. See http://confluence.atlassian.com/display/JIRA/Increasing+JIRA+memory
rem
rem --------------------------------------------------------------------------

rem --------------------------------------------------------------------------
rem
rem  Occasionally Atlassian Support may recommend that you set some specific JVM arguments.  You can use this variable below to do that.
rem
rem --------------------------------------------------------------------------
set JVM_SUPPORT_RECOMMENDED_ARGS=


rem --------------------------------------------------------------------------
rem
rem The following 2 settings control the minimum and maximum given to the JIRA Java virtual machine.  In larger JIRA instances, the maximum amount will need to be increased.
rem
rem --------------------------------------------------------------------------
set JVM_MINIMUM_MEMORY=256m
set JVM_MAXIMUM_MEMORY=768m

rem --------------------------------------------------------------------------
rem
rem The following are the required arguments need for JIRA standalone.
rem
rem --------------------------------------------------------------------------
set JVM_REQUIRED_ARGS=-Djava.awt.headless=true -Datlassian.standalone=JIRA -Dorg.apache.jasper.runtime.BodyContentImpl.LIMIT_BUFFER=true -Dmail.mime.decodeparameters=true

rem --------------------------------------------------------------------------
rem Uncomment this setting if you want to import data without notifications
rem
rem --------------------------------------------------------------------------
rem DISABLE_NOTIFICATIONS= -Datlassian.mail.senddisabled=true -Datlassian.mail.fetchdisabled=true -Datlassian.mail.popdisabled=true


rem --------------------------------------------------------------------------
rem
rem In general don't make changes below here
rem
rem --------------------------------------------------------------------------
set JAVA_OPTS=%JAVA_OPTS% -Xms%JVM_MINIMUM_MEMORY% -Xmx%JVM_MAXIMUM_MEMORY% %JVM_REQUIRED_ARGS% %DISABLE_NOTIFICATIONS% %JVM_SUPPORT_RECOMMENDED_ARGS%

set _PRG_DIR=%~dp0

type %_PRG_DIR%\jirabanner.txt

rem Checks if the JAVA_HOME has a space in it (can cause issues)
SET _marker=%JAVA_HOME: =%
IF NOT "%_marker%" == "%JAVA_HOME%" ECHO JAVA_HOME "%JAVA_HOME%" contains spaces. Please change to a location without spaces if this causes problems.

rem Perm Gen size needs to be increased if encountering OutOfMemoryError: PermGen problems. Specifying PermGen size is not valid on IBM JDKs
set JIRA_MAX_PERM_SIZE=256m
IF EXIST "%_PRG_DIR%\permgen.bat" goto startPermGenCheck
goto skipPermGenCheck
:startPermGenCheck
call "%_PRG_DIR%\permgen.bat"
if ERRORLEVEL 1 goto endPermGenCheck
set JAVA_OPTS=-XX:MaxPermSize=%JIRA_MAX_PERM_SIZE% %JAVA_OPTS%
:endPermGenCheck
set JIRA_MAX_PERM_SIZE=
rem Clear the errorlevel which may have been set by permgen.bat
cmd /c
:skipPermGenCheck

echo If you encounter issues starting or stopping JIRA Standalone Edition, please see the Troubleshooting guide at http://confluence.atlassian.com/display/JIRA/Installation+Troubleshooting+Guide
