/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.user;

import com.opensymphony.user.provider.AccessProvider;
import com.opensymphony.user.provider.CredentialsProvider;
import com.opensymphony.user.provider.ProfileProvider;
import com.opensymphony.user.provider.UserProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Configuration {
    public List<CredentialsProvider> getCredentialsProviders();

    public List<AccessProvider> getAccessProviders();

    public List<ProfileProvider> getProfileProviders();

    public static class Builder {
        private final List<AccessProvider> accessProviders = new ArrayList<AccessProvider>();
        private final List<CredentialsProvider> credentialsProviders = new ArrayList<CredentialsProvider>();
        private final List<ProfileProvider> profileProviders = new ArrayList<ProfileProvider>();

        public void addProvider(UserProvider provider) {
            if (provider instanceof CredentialsProvider) {
                this.credentialsProviders.add((CredentialsProvider)provider);
            }
            if (provider instanceof ProfileProvider) {
                this.profileProviders.add((ProfileProvider)provider);
            }
            if (provider instanceof AccessProvider) {
                this.accessProviders.add((AccessProvider)provider);
            }
        }

        public Configuration toConfiguration() {
            return new Configuration(){

                @Override
                public List<AccessProvider> getAccessProviders() {
                    return Collections.unmodifiableList(Builder.this.accessProviders);
                }

                @Override
                public List<CredentialsProvider> getCredentialsProviders() {
                    return Collections.unmodifiableList(Builder.this.credentialsProviders);
                }

                @Override
                public List<ProfileProvider> getProfileProviders() {
                    return Collections.unmodifiableList(Builder.this.profileProviders);
                }
            };
        }
    }
}

