/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.job;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.ofbiz.core.calendar.RecurrenceInfo;
import org.ofbiz.core.calendar.RecurrenceInfoException;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.serialize.SerializeException;
import org.ofbiz.core.serialize.XmlSerializer;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericRequester;
import org.ofbiz.core.service.job.GenericServiceJob;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilDateTime;
import org.ofbiz.core.util.UtilMisc;
import org.xml.sax.SAXException;

public class PersistedServiceJob
extends GenericServiceJob {
    public static final String module = PersistedServiceJob.class.getName();
    private transient GenericDelegator delegator = null;
    private Timestamp storedDate = null;

    public PersistedServiceJob(DispatchContext dctx, GenericValue jobValue, GenericRequester req) {
        super(jobValue.getString("jobName"));
        this.delegator = dctx.getDelegator();
        this.requester = req;
        this.dctx = dctx;
        this.storedDate = jobValue.getTimestamp("runTime");
        this.runtime = this.storedDate.getTime();
    }

    protected void init() {
        GenericValue job = this.getJob();
        RecurrenceInfo recurrence = this.getRecurrence();
        try {
            GenericValue newJob = new GenericValue(job);
            job.set("startDateTime", (Object)UtilDateTime.nowTimestamp());
            job.store();
            if (recurrence != null) {
                recurrence.incrementCurrentCount();
                long next = recurrence.next();
                if (Debug.verboseOn()) {
                    Debug.logVerbose((String)("Next runtime returned: " + next), (String)module);
                }
                if (next > this.runtime) {
                    newJob.set("runTime", (Object)new Timestamp(next));
                    this.delegator.create(newJob);
                    if (Debug.verboseOn()) {
                        Debug.logVerbose((String)("Created next job entry: " + newJob), (String)module);
                    }
                }
            }
        }
        catch (GenericEntityException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)(this.toString() + " -- Next runtime: " + this.runtime), (String)module);
        }
    }

    protected void finish() {
        GenericValue job = this.getJob();
        job.set("finishDateTime", (Object)UtilDateTime.nowTimestamp());
        try {
            job.store();
        }
        catch (GenericEntityException e) {
            Debug.logError((Throwable)e, (String)"Cannot update the datasource");
        }
    }

    protected String getServiceName() {
        GenericValue jobObj = this.getJob();
        if (jobObj == null || jobObj.get("serviceName") == null) {
            return null;
        }
        return jobObj.getString("serviceName");
    }

    protected Map getContext() {
        Map context = null;
        try {
            GenericValue jobObj = this.getJob();
            GenericValue contextObj = jobObj.getRelatedOne("RuntimeData");
            if (contextObj != null) {
                context = (Map)XmlSerializer.deserialize((String)contextObj.getString("runtimeInfo"), (GenericDelegator)this.delegator);
            }
        }
        catch (GenericEntityException e) {
            Debug.logError((Throwable)e, (String)module);
        }
        catch (SerializeException e) {
            Debug.logError((Throwable)e, (String)module);
        }
        catch (ParserConfigurationException e) {
            Debug.logError((Throwable)e, (String)module);
        }
        catch (SAXException e) {
            Debug.logError((Throwable)e, (String)module);
        }
        catch (IOException e) {
            Debug.logError((Throwable)e, (String)module);
        }
        if (context == null) {
            Debug.logError((String)"Job context is null", (String)module);
        }
        return context;
    }

    private GenericValue getJob() {
        try {
            Map fields = UtilMisc.toMap((String)"jobName", (Object)this.getJobName(), (String)"runTime", (Object)this.storedDate);
            GenericValue jobObj = this.delegator.findByPrimaryKey("JobSandbox", fields);
            if (jobObj == null) {
                Debug.logError((String)"Job came back null from datasource", (String)module);
            }
            return jobObj;
        }
        catch (GenericEntityException e) {
            Debug.logError((Throwable)e, (String)"Cannot get job definition from entity", (String)module);
            e.printStackTrace();
            return null;
        }
    }

    private RecurrenceInfo getRecurrence() {
        try {
            GenericValue job = this.getJob();
            if (job != null) {
                GenericValue ri = job.getRelatedOne("RecurrenceInfo");
                if (ri != null) {
                    return new RecurrenceInfo(ri);
                }
                return null;
            }
            return null;
        }
        catch (GenericEntityException e) {
            e.printStackTrace();
            Debug.logError((Throwable)e, (String)"Problem getting RecurrenceInfo entity from JobSandbox", (String)module);
        }
        catch (RecurrenceInfoException re) {
            re.printStackTrace();
            Debug.logError((Throwable)re, (String)("Problem creating RecurrenceInfo instance: " + re.getMessage()), (String)module);
        }
        return null;
    }
}

