/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.job;

import java.util.Date;
import java.util.Map;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericRequester;
import org.ofbiz.core.service.LocalDispatcher;
import org.ofbiz.core.service.job.AbstractJob;
import org.ofbiz.core.util.Debug;

public class GenericServiceJob
extends AbstractJob {
    public static final String module = GenericServiceJob.class.getName();
    protected transient GenericRequester requester = null;
    protected transient DispatchContext dctx = null;
    private boolean trans = false;
    private String service = null;
    private Map context = null;

    public GenericServiceJob(DispatchContext dctx, String jobName, String service, Map context, GenericRequester req) {
        this(dctx, jobName, service, context, req, true);
    }

    public GenericServiceJob(DispatchContext dctx, String jobName, String service, Map context, GenericRequester req, boolean trans) {
        super(jobName);
        this.dctx = dctx;
        this.service = service;
        this.context = context;
        this.requester = req;
        this.trans = trans;
        this.runtime = new Date().getTime();
    }

    protected GenericServiceJob(String jobName) {
        super(jobName);
        this.dctx = null;
        this.requester = null;
        this.service = null;
        this.context = null;
    }

    public void exec() {
        this.init();
        boolean begunTransaction = false;
        if (this.trans) {
            try {
                begunTransaction = TransactionUtil.begin();
            }
            catch (GenericTransactionException te) {
                Debug.logError((Throwable)te, (String)module);
            }
        }
        try {
            LocalDispatcher dispatcher = this.dctx.getDispatcher();
            Map result = dispatcher.runSync(this.getServiceName(), this.getContext());
            if (this.requester != null) {
                this.requester.receiveResult(result);
            }
            this.finish();
            boolean isError = "error".equals(result.get("responseMessage"));
            if (this.trans && begunTransaction) {
                if (!isError) {
                    try {
                        TransactionUtil.commit((boolean)begunTransaction);
                    }
                    catch (GenericTransactionException te) {
                        Debug.logError((Throwable)te, (String)"Cannot commit transaction", (String)module);
                    }
                } else {
                    try {
                        TransactionUtil.rollback((boolean)begunTransaction);
                    }
                    catch (GenericTransactionException te) {
                        Debug.logError((Throwable)te, (String)"Cannot rollback transaction", (String)module);
                    }
                }
            }
        }
        catch (Exception e) {
            if (this.trans && begunTransaction) {
                try {
                    TransactionUtil.rollback((boolean)begunTransaction);
                }
                catch (GenericTransactionException te) {
                    Debug.logError((Throwable)te, (String)"Cannot rollback transaction", (String)module);
                }
            }
            if (this.requester != null) {
                this.requester.receiveException(e);
            }
            this.failed(e);
        }
    }

    protected void init() {
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)"Async-Service initializing.", (String)module);
        }
    }

    protected void finish() {
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)"Async-Service finished.", (String)module);
        }
        this.runtime = 0L;
    }

    protected void failed(Exception e) {
        Debug.logError((Throwable)e, (String)"Async-Service failed.", (String)module);
        this.runtime = 0L;
    }

    protected Map getContext() {
        return this.context;
    }

    protected String getServiceName() {
        return this.service;
    }
}

