/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.jms;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.config.ServiceConfigUtil;
import org.ofbiz.core.service.jms.GenericMessageListener;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilXml;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JmsListenerFactory
implements Runnable {
    public static final String module = JmsListenerFactory.class.getName();
    public static final String TOPIC_LISTENER_CLASS = "org.ofbiz.core.service.jms.JmsTopicListener";
    public static final String QUEUE_LISTENER_CLASS = "org.ofbiz.core.service.jms.JmsQueueListener";
    protected static Map listeners = new HashMap();
    protected static Map servers = new HashMap();
    protected ServiceDispatcher dispatcher;
    protected boolean firstPass = true;
    protected int loadable = 0;
    protected int connected = 0;
    protected Thread thread;

    public JmsListenerFactory(ServiceDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.thread = new Thread((Runnable)this, this.toString());
        this.thread.setDaemon(false);
        this.thread.start();
    }

    public void run() {
        Debug.logInfo((String)"Starting JMS Listener Factory Thread...", (String)module);
        while (this.firstPass || this.connected < this.loadable) {
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("First Pass: " + this.firstPass + " Connected: " + this.connected + " Available: " + this.loadable), (String)module);
            }
            this.loadListeners();
            this.firstPass = false;
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Debug.logInfo((String)"JMS Listener Factory Thread Finished; All listeners connected.", (String)module);
    }

    private void loadListeners() {
        try {
            Element rootElement = ServiceConfigUtil.getXmlRootElement();
            NodeList nodeList = rootElement.getElementsByTagName("jms-service");
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)"[ServiceDispatcher] : Loading JMS Listeners.", (String)module);
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                List serverList = UtilXml.childElementList((Element)element, (String)"server");
                for (Element server : serverList) {
                    try {
                        String listenerEnabled = server.getAttribute("listen");
                        if (!listenerEnabled.equalsIgnoreCase("true")) continue;
                        StringBuffer serverKey = new StringBuffer();
                        serverKey.append(server.getAttribute("jndi-server-name") + ":");
                        serverKey.append(server.getAttribute("jndi-name") + ":");
                        serverKey.append(server.getAttribute("topic-queue"));
                        servers.put(serverKey.toString(), server);
                        GenericMessageListener listener = this.loadListener(serverKey.toString(), server);
                        if (serverKey.length() <= 0 || listener == null) continue;
                        listeners.put(serverKey.toString(), listener);
                    }
                    catch (GenericServiceException gse) {
                        Debug.logVerbose((String)("Cannot load message listener (" + gse.toString() + ")."), (String)module);
                    }
                    catch (Exception e) {
                        Debug.logError((Throwable)e, (String)"Uncaught exception.", (String)module);
                    }
                }
            }
        }
        catch (GenericConfigException gce) {
            Debug.logError((Throwable)gce, (String)"Cannot get serviceengine.xml root element.", (String)module);
        }
        catch (Exception e) {
            Debug.logError((Throwable)e, (String)"Uncaught exception.", (String)module);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenericMessageListener loadListener(String serverKey, Element server) throws GenericServiceException {
        GenericMessageListener listener;
        String serverName = server.getAttribute("jndi-server-name");
        String jndiName = server.getAttribute("jndi-name");
        String queueName = server.getAttribute("topic-queue");
        String type = server.getAttribute("type");
        String userName = server.getAttribute("username");
        String password = server.getAttribute("password");
        String className = server.getAttribute("listener-class");
        if (className == null || className.length() == 0) {
            if (type.equals("topic")) {
                className = TOPIC_LISTENER_CLASS;
            } else if (type.equals("queue")) {
                className = QUEUE_LISTENER_CLASS;
            }
        }
        if ((listener = (GenericMessageListener)listeners.get(serverKey)) == null) {
            JmsListenerFactory jmsListenerFactory = this;
            synchronized (jmsListenerFactory) {
                listener = (GenericMessageListener)listeners.get(serverKey);
                if (listener == null) {
                    ClassLoader cl = this.getClass().getClassLoader();
                    Class[] paramTypes = new Class[]{ServiceDispatcher.class, String.class, String.class, String.class, String.class, String.class};
                    Object[] params = new Object[]{this.dispatcher, serverName, jndiName, queueName, userName, password};
                    try {
                        Class<?> c = cl.loadClass(className);
                        Constructor<?> cn = c.getConstructor(paramTypes);
                        listener = (GenericMessageListener)cn.newInstance(params);
                    }
                    catch (Exception e) {
                        throw new GenericServiceException(e.getMessage(), e);
                    }
                    if (listener != null) {
                        listeners.put(serverKey, listener);
                    }
                    ++this.loadable;
                }
            }
        }
        if (listener != null && !listener.isConnected()) {
            listener.load();
            if (listener.isConnected()) {
                ++this.connected;
            }
        }
        return listener;
    }

    public void loadListener(String serverKey) throws GenericServiceException {
        Element server = (Element)servers.get(serverKey);
        if (server == null) {
            throw new GenericServiceException("No listener found with that serverKey.");
        }
        this.loadListener(serverKey, server);
    }

    public void closeListeners() throws GenericServiceException {
        this.loadable = 0;
        Set listenerKeys = listeners.keySet();
        for (String serverKey : listenerKeys) {
            this.closeListener(serverKey);
        }
    }

    public void closeListener(String serverKey) throws GenericServiceException {
        GenericMessageListener listener = (GenericMessageListener)listeners.get(serverKey);
        if (listener == null) {
            throw new GenericServiceException("No listener found with that serverKey.");
        }
        listener.close();
    }

    public void refreshListener(String serverKey) throws GenericServiceException {
        GenericMessageListener listener = (GenericMessageListener)listeners.get(serverKey);
        if (listener == null) {
            throw new GenericServiceException("No listener found with that serverKey.");
        }
        listener.refresh();
    }

    public Map getJMSListeners() {
        return new HashMap(listeners);
    }
}

