/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service.engine;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.engine.GenericAsyncEngine;
import org.ofbiz.core.util.Debug;

public final class StandardJavaEngine
extends GenericAsyncEngine {
    public static final String module = StandardJavaEngine.class.getName();

    public StandardJavaEngine(ServiceDispatcher dispatcher) {
        super(dispatcher);
    }

    public void runSyncIgnore(String localName, ModelService modelService, Map context) throws GenericServiceException {
        Map result = this.runSync(localName, modelService, context);
    }

    public Map runSync(String localName, ModelService modelService, Map context) throws GenericServiceException {
        Object result = this.serviceInvoker(localName, modelService, context);
        if (result == null || !(result instanceof Map)) {
            throw new GenericServiceException("Service did not return expected result");
        }
        return (Map)result;
    }

    private Object serviceInvoker(String localName, ModelService modelService, Map context) throws GenericServiceException {
        DispatchContext dctx = this.dispatcher.getLocalContext(localName);
        if (modelService == null) {
            Debug.logError((String)"ERROR: Null Model Service.", (String)module);
        }
        if (dctx == null) {
            Debug.logError((String)"ERROR: Null DispatchContext.", (String)module);
        }
        if (context == null) {
            Debug.logError((String)"ERROR: Null Service Context.", (String)module);
        }
        Class[] paramTypes = new Class[]{DispatchContext.class, Map.class};
        Object[] params = new Object[]{dctx, context};
        Object result = null;
        if (modelService.location == null || modelService.invoke == null) {
            throw new GenericServiceException("Cannot locate service to invoke (location or invoke name missing)");
        }
        ClassLoader cl = null;
        cl = dctx == null ? this.getClass().getClassLoader() : dctx.getClassLoader();
        try {
            Class<?> c = cl.loadClass(modelService.location);
            Method m = c.getMethod(modelService.invoke, paramTypes);
            result = m.invoke(null, params);
        }
        catch (ClassNotFoundException cnfe) {
            throw new GenericServiceException("Cannot find service location", cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new GenericServiceException("Service method does not exist", nsme);
        }
        catch (SecurityException se) {
            throw new GenericServiceException("Access denied", se);
        }
        catch (IllegalAccessException iae) {
            throw new GenericServiceException("Method not accessible", iae);
        }
        catch (IllegalArgumentException iarge) {
            throw new GenericServiceException("Invalid parameter match", iarge);
        }
        catch (InvocationTargetException ite) {
            Debug.logWarning((Throwable)ite);
            throw new GenericServiceException("Service target threw an unexpected exception", ite.getTargetException());
        }
        catch (NullPointerException npe) {
            throw new GenericServiceException("Specified object is null", npe);
        }
        catch (ExceptionInInitializerError eie) {
            throw new GenericServiceException("Initialization failed", eie);
        }
        catch (Exception ex) {
            throw new GenericServiceException("Unknown exception", ex);
        }
        return result;
    }
}

