/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericTransactionException;
import org.ofbiz.core.entity.GenericValue;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.entity.TransactionUtil;
import org.ofbiz.core.security.Security;
import org.ofbiz.core.security.SecurityConfigurationException;
import org.ofbiz.core.security.SecurityFactory;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericRequester;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.LocalDispatcher;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceAuthException;
import org.ofbiz.core.service.ServiceValidationException;
import org.ofbiz.core.service.config.ServiceConfigUtil;
import org.ofbiz.core.service.eca.ServiceEcaUtil;
import org.ofbiz.core.service.engine.GenericEngine;
import org.ofbiz.core.service.engine.GenericEngineFactory;
import org.ofbiz.core.service.group.ServiceGroupReader;
import org.ofbiz.core.service.jms.JmsListenerFactory;
import org.ofbiz.core.service.job.JobManager;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilMisc;

public class ServiceDispatcher {
    public static final String module = ServiceDispatcher.class.getName();
    protected static Map dispatchers = new HashMap();
    protected GenericDelegator delegator = null;
    protected GenericEngineFactory factory = null;
    protected Security security = null;
    protected Map localContext = null;
    protected JobManager jm = null;
    protected JmsListenerFactory jlf = null;

    public ServiceDispatcher(GenericDelegator delegator) {
        Debug.logInfo((String)"[ServiceDispatcher] : Creating new instance.", (String)module);
        this.factory = new GenericEngineFactory(this);
        ServiceGroupReader.readConfig();
        ServiceEcaUtil.readConfig();
        this.delegator = delegator;
        this.localContext = new HashMap();
        if (delegator != null) {
            try {
                this.security = SecurityFactory.getInstance((GenericDelegator)delegator);
            }
            catch (SecurityConfigurationException e) {
                Debug.logError((Throwable)e, (String)"[ServiceDispatcher.init] : No instance of security imeplemtation found.", (String)module);
            }
        }
        this.jm = new JobManager(this, this.delegator);
        this.jlf = new JmsListenerFactory(this);
    }

    public static ServiceDispatcher getInstance(String name, GenericDelegator delegator) {
        ServiceDispatcher sd = ServiceDispatcher.getInstance(null, null, delegator);
        if (!sd.containsContext(name)) {
            return null;
        }
        return sd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static ServiceDispatcher getInstance(String name, DispatchContext context, GenericDelegator delegator) {
        ServiceDispatcher sd = null;
        String dispatcherKey = delegator != null ? delegator.getDelegatorName() : "null";
        sd = (ServiceDispatcher)dispatchers.get(dispatcherKey);
        if (sd == null) {
            Class<ServiceDispatcher> clazz = ServiceDispatcher.class;
            // MONITORENTER : org.ofbiz.core.service.ServiceDispatcher.class
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[ServiceDispatcher.getInstance] : No instance found (" + delegator.getDelegatorName() + ")."), (String)module);
            }
            if ((sd = (ServiceDispatcher)dispatchers.get(dispatcherKey)) == null) {
                sd = new ServiceDispatcher(delegator);
                dispatchers.put(dispatcherKey, sd);
            }
            // MONITOREXIT : clazz
        }
        if (name == null) return sd;
        if (context == null) return sd;
        sd.register(name, context);
        return sd;
    }

    public void register(String name, DispatchContext context) {
        if (Debug.infoOn()) {
            Debug.logInfo((String)("[ServiceDispatcher.register] : Registered dispatcher: " + context.getName()), (String)module);
        }
        this.localContext.put(name, context);
    }

    public void deregister(LocalDispatcher local) {
        if (Debug.infoOn()) {
            Debug.logInfo((String)("[ServiceDispatcher.deregister] : De-Registering dispatcher: " + local.getName()), (String)module);
        }
        this.localContext.remove(local.getName());
        if (this.localContext.size() == 1) {
            try {
                this.shutdown();
            }
            catch (GenericServiceException e) {
                Debug.logError((Throwable)((Object)e), (String)"Trouble shutting down ServiceDispatcher!", (String)module);
            }
        }
    }

    public Map runSync(String localName, ModelService service, Map context) throws GenericServiceException {
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[ServiceDispatcher.runSync] : invoking service " + service.name + " [" + service.location + "/" + service.invoke + "] (" + service.engineName + ")"), (String)module);
        }
        this.checkLocale(context);
        TransactionManager tm = TransactionFactory.getTransactionManager();
        Transaction parentTransaction = null;
        boolean beganTrans = false;
        if (service.useTransaction) {
            try {
                beganTrans = TransactionUtil.begin();
            }
            catch (GenericTransactionException te) {
                throw new GenericServiceException("Cannot start the transaction.", te.getNested());
            }
            if (service.requireNewTransaction && !beganTrans) {
                try {
                    parentTransaction = tm.suspend();
                }
                catch (SystemException se) {
                    Debug.logError((Throwable)se, (String)"Problems suspending current transaction", (String)module);
                    throw new GenericServiceException("Problems suspending transaction, see logs");
                }
                try {
                    beganTrans = TransactionUtil.begin();
                }
                catch (GenericTransactionException gte) {
                    throw new GenericServiceException("Cannot start the transaction.", gte.getNested());
                }
            }
        }
        DispatchContext ctx = (DispatchContext)this.localContext.get(localName);
        try {
            Map eventMap = ServiceEcaUtil.getServiceEventMap(service.name);
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "auth", ctx, context, null, false);
            }
            context = this.checkAuth(localName, context, service);
            Object userLogin = context.get("userLogin");
            if (service.auth && userLogin == null) {
                throw new ServiceAuthException("User authorization is required for the " + service.name + " service");
            }
            GenericEngine engine = this.getGenericEngine(service.engineName);
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "in-validate", ctx, context, null, false);
            }
            if (service.validate) {
                try {
                    service.validate(context, "IN");
                }
                catch (ServiceValidationException e) {
                    throw new GenericServiceException("Context (in runSync) does not match expected requirements: ", (Throwable)((Object)e));
                }
            }
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "invoke", ctx, context, null, false);
            }
            Map result = engine.runSync(localName, service, context);
            boolean isError = "error".equals(result.get("responseMessage"));
            HashMap ecaContext = new HashMap(context);
            ecaContext.putAll(result);
            if (service.validate) {
                if (eventMap != null) {
                    ServiceEcaUtil.evalRules(service.name, eventMap, "out-validate", ctx, ecaContext, result, isError);
                }
                try {
                    service.validate(result, "OUT");
                }
                catch (ServiceValidationException e) {
                    throw new GenericServiceException("Result (in runSync) does not match expected requirements: ", (Throwable)((Object)e));
                }
            }
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "commit", ctx, ecaContext, result, isError);
            }
            if (isError) {
                try {
                    TransactionUtil.rollback((boolean)beganTrans);
                }
                catch (GenericTransactionException e) {
                    Debug.logError((Throwable)e, (String)"Could not rollback transaction", (String)module);
                }
            } else {
                try {
                    TransactionUtil.commit((boolean)beganTrans);
                }
                catch (GenericTransactionException e) {
                    Debug.logError((Throwable)e, (String)"Could not commit transaction", (String)module);
                    throw new GenericServiceException("Commit transaction failed");
                }
            }
            if (parentTransaction != null) {
                try {
                    tm.resume(parentTransaction);
                }
                catch (InvalidTransactionException ite) {
                    Debug.logWarning((Throwable)ite, (String)"Invalid transaction, not resumed", (String)module);
                }
                catch (IllegalStateException ise) {
                    Debug.logError((Throwable)ise, (String)"Trouble resuming parent transaction", (String)module);
                    throw new GenericServiceException("Resume transaction exception, see logs");
                }
                catch (SystemException se) {
                    Debug.logError((Throwable)se, (String)"Trouble resuming parent transaction", (String)module);
                    throw new GenericServiceException("Resume transaction exception, see logs");
                }
            }
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "return", ctx, ecaContext, result, isError);
            }
            return result;
        }
        catch (GenericServiceException e) {
            try {
                TransactionUtil.rollback((boolean)beganTrans);
            }
            catch (GenericTransactionException te) {
                Debug.logError((Throwable)te, (String)"Cannot rollback transaction", (String)module);
            }
            throw e;
        }
    }

    public void runSyncIgnore(String localName, ModelService service, Map context) throws GenericServiceException {
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[ServiceDispatcher.runSyncIgnore] : invoking service " + service.name + " [" + service.location + "/" + service.invoke + "] (" + service.engineName + ")"), (String)module);
        }
        this.checkLocale(context);
        TransactionManager tm = TransactionFactory.getTransactionManager();
        Transaction parentTransaction = null;
        boolean beganTrans = false;
        if (service.useTransaction) {
            try {
                beganTrans = TransactionUtil.begin();
            }
            catch (GenericTransactionException te) {
                throw new GenericServiceException("Cannot start the transaction.", te.getNested());
            }
            if (service.requireNewTransaction && !beganTrans) {
                try {
                    parentTransaction = tm.suspend();
                }
                catch (SystemException se) {
                    Debug.logError((Throwable)se, (String)"Problems suspending current transaction", (String)module);
                    throw new GenericServiceException("Problems suspending transaction, see logs");
                }
                try {
                    beganTrans = TransactionUtil.begin();
                }
                catch (GenericTransactionException gte) {
                    throw new GenericServiceException("Cannot start the transaction.", gte.getNested());
                }
            }
        }
        DispatchContext ctx = (DispatchContext)this.localContext.get(localName);
        try {
            Map eventMap = ServiceEcaUtil.getServiceEventMap(service.name);
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "auth", ctx, context, null, false);
            }
            context = this.checkAuth(localName, context, service);
            Object userLogin = context.get("userLogin");
            if (service.auth && userLogin == null) {
                throw new ServiceAuthException("User authorization is required for this service");
            }
            GenericEngine engine = this.getGenericEngine(service.engineName);
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "in-validate", ctx, context, null, false);
            }
            if (service.validate) {
                try {
                    service.validate(context, "IN");
                }
                catch (ServiceValidationException e) {
                    throw new GenericServiceException("Context (in runSync) does not match expected requirements: ", (Throwable)((Object)e));
                }
            }
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "invoke", ctx, context, null, false);
            }
            engine.runSyncIgnore(localName, service, context);
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "commit", ctx, context, null, false);
            }
            try {
                TransactionUtil.commit((boolean)beganTrans);
            }
            catch (GenericTransactionException e) {
                Debug.logError((Throwable)e, (String)"Could not commit transaction", (String)module);
                throw new GenericServiceException("Commit transaction failed");
            }
            if (parentTransaction != null) {
                try {
                    tm.resume(parentTransaction);
                }
                catch (InvalidTransactionException ite) {
                    Debug.logWarning((Throwable)ite, (String)"Invalid transaction, not resumed", (String)module);
                }
                catch (IllegalStateException ise) {
                    Debug.logError((Throwable)ise, (String)"Trouble resuming parent transaction", (String)module);
                    throw new GenericServiceException("Resume transaction exception, see logs");
                }
                catch (SystemException se) {
                    Debug.logError((Throwable)se, (String)"Trouble resuming parent transaction", (String)module);
                    throw new GenericServiceException("Resume transaction exception, see logs");
                }
            }
            if (eventMap != null) {
                ServiceEcaUtil.evalRules(service.name, eventMap, "return", ctx, context, null, false);
            }
        }
        catch (GenericServiceException e) {
            try {
                TransactionUtil.rollback((boolean)beganTrans);
            }
            catch (GenericTransactionException te) {
                Debug.logError((Throwable)te, (String)"Cannot rollback transaction", (String)module);
            }
            throw e;
        }
    }

    public void runAsync(String localName, ModelService service, Map context, GenericRequester requester, boolean persist) throws GenericServiceException {
        this.checkLocale(context);
        Map eventMap = ServiceEcaUtil.getServiceEventMap(service.name);
        DispatchContext ctx = (DispatchContext)this.localContext.get(localName);
        if (eventMap != null) {
            ServiceEcaUtil.evalRules(service.name, eventMap, "auth", ctx, context, null, false);
        }
        context = this.checkAuth(localName, context, service);
        Object userLogin = context.get("userLogin");
        if (service.auth && userLogin == null) {
            throw new ServiceAuthException("User authorization is required for this service");
        }
        GenericEngine engine = this.getGenericEngine(service.engineName);
        if (eventMap != null) {
            ServiceEcaUtil.evalRules(service.name, eventMap, "in-validate", ctx, context, null, false);
        }
        if (service.validate) {
            try {
                service.validate(context, "IN");
            }
            catch (ServiceValidationException e) {
                throw new GenericServiceException("Context (in runAsync) does not match expected requirements: ", (Throwable)((Object)e));
            }
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[ServiceDispatcher.runAsync] : invoking service [" + service.location + "/" + service.invoke + "] (" + service.engineName + ")"), (String)module);
        }
        engine.runAsync(localName, service, context, requester, persist);
    }

    public void runAsync(String localName, ModelService service, Map context, boolean persist) throws GenericServiceException {
        this.checkLocale(context);
        Map eventMap = ServiceEcaUtil.getServiceEventMap(service.name);
        DispatchContext ctx = (DispatchContext)this.localContext.get(localName);
        if (eventMap != null) {
            ServiceEcaUtil.evalRules(service.name, eventMap, "auth", ctx, context, null, false);
        }
        context = this.checkAuth(localName, context, service);
        Object userLogin = context.get("userLogin");
        if (service.auth && userLogin == null) {
            throw new ServiceAuthException("User authorization is required for this service");
        }
        GenericEngine engine = this.getGenericEngine(service.engineName);
        if (eventMap != null) {
            ServiceEcaUtil.evalRules(service.name, eventMap, "in-validate", ctx, context, null, false);
        }
        if (service.validate) {
            try {
                service.validate(context, "IN");
            }
            catch (ServiceValidationException e) {
                throw new GenericServiceException("Context (in runSync) does not match expected requirements: ", (Throwable)((Object)e));
            }
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[ServiceDispatcher.runAsync] : invoking service [" + service.location + "/" + service.invoke + "] (" + service.engineName + ")"), (String)module);
        }
        engine.runAsync(localName, service, context, persist);
    }

    public GenericEngine getGenericEngine(String engineName) throws GenericServiceException {
        return this.factory.getGenericEngine(engineName);
    }

    public JobManager getJobManager() {
        return this.jm;
    }

    public JmsListenerFactory getJMSListenerFactory() {
        return this.jlf;
    }

    public GenericDelegator getDelegator() {
        return this.delegator;
    }

    public Security getSecurity() {
        return this.security;
    }

    public DispatchContext getLocalContext(String name) {
        return (DispatchContext)this.localContext.get(name);
    }

    public LocalDispatcher getLocalDispatcher(String name) {
        return ((DispatchContext)this.localContext.get(name)).getDispatcher();
    }

    public boolean containsContext(String name) {
        return this.localContext.containsKey(name);
    }

    public void shutdown() throws GenericServiceException {
        Debug.logInfo((String)"Shutting down the service engine...", (String)module);
        this.jlf.closeListeners();
        this.jm.finalize();
    }

    private Map checkAuth(String localName, Map context, ModelService origService) throws GenericServiceException {
        String service = ServiceConfigUtil.getElementAttr("authorization", "service-name");
        if (service == null) {
            throw new GenericServiceException("No Authentication Service Defined");
        }
        if (service.equals(origService.name)) {
            return context;
        }
        if (context.containsKey("login.username")) {
            String username = (String)context.get("login.username");
            if (context.containsKey("login.password")) {
                String password = (String)context.get("login.password");
                context.put("userLogin", this.getLoginObject(service, localName, username, password));
                context.remove("login.password");
            } else {
                context.put("userLogin", this.getLoginObject(service, localName, username, null));
            }
            context.remove("login.username");
        } else {
            GenericValue newUserLogin;
            GenericValue userLogin = (GenericValue)context.get("userLogin");
            if (userLogin != null && (newUserLogin = this.getLoginObject(service, localName, userLogin.getString("userLoginId"), userLogin.getString("currentPassword"))) == null) {
                context.remove("userLogin");
            }
        }
        return context;
    }

    private GenericValue getLoginObject(String service, String localName, String username, String password) throws GenericServiceException {
        Map context = UtilMisc.toMap((String)"login.username", (Object)username, (String)"login.password", (Object)password, (String)"isServiceAuth", (Object)new Boolean(true));
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)"[ServiceDispathcer.authenticate] : Invoking UserLogin Service", (String)module);
        }
        DispatchContext dctx = this.getLocalContext(localName);
        ModelService model = dctx.getModelService(service);
        GenericEngine engine = this.getGenericEngine(model.engineName);
        Map result = engine.runSync(localName, model, context);
        GenericValue value = (GenericValue)result.get("userLogin");
        return value;
    }

    private void checkLocale(Map context) {
        Object locale = context.get("locale");
        Locale newLocale = null;
        if (locale != null) {
            if (locale instanceof Locale) {
                return;
            }
            if (locale instanceof String) {
                newLocale = UtilMisc.parseLocale((String)((String)locale));
            }
        }
        if (newLocale == null) {
            newLocale = Locale.getDefault();
        }
        context.put("locale", newLocale);
    }
}

