/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service;

import java.util.Map;
import org.ofbiz.core.service.GenericRequester;
import org.ofbiz.core.util.Debug;

public class GenericResultWaiter
implements GenericRequester {
    public static final String module = GenericResultWaiter.class.getName();
    public static final int SERVICE_RUNNING = -1;
    public static final int SERVICE_FAILED = 0;
    public static final int SERVICE_FINISHED = 1;
    private boolean completed = false;
    private int status = -1;
    private Map result = null;
    private Exception exception = null;

    public synchronized void receiveResult(Map result) {
        this.result = result;
        this.completed = true;
        this.status = 1;
        this.notify();
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("Received Result (" + this.completed + ") -- " + result), (String)module);
        }
    }

    public synchronized void receiveException(Exception exception) {
        this.exception = exception;
        this.completed = true;
        this.status = 0;
        this.notify();
    }

    public synchronized int status() {
        return this.status;
    }

    public synchronized boolean isCompleted() {
        return this.completed;
    }

    public synchronized Exception getException() {
        if (!this.isCompleted()) {
            throw new IllegalStateException("Cannot return exception, synchronous call has not completed.");
        }
        return this.exception;
    }

    public synchronized Map getResult() {
        if (!this.isCompleted()) {
            throw new IllegalStateException("Cannot return result, asynchronous call has not completed.");
        }
        return this.result;
    }

    public synchronized Map waitForResult() {
        return this.waitForResult(10L);
    }

    public synchronized Map waitForResult(long milliseconds) {
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)"Waiting for results...", (String)module);
        }
        while (!this.isCompleted()) {
            try {
                this.wait(milliseconds);
                if (!Debug.verboseOn()) continue;
                Debug.logVerbose((String)"Waiting...", (String)module);
            }
            catch (InterruptedException e) {
                Debug.logError((Throwable)e);
            }
        }
        return this.getResult();
    }
}

