/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service;

import java.util.Map;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericAbstractDispatcher;
import org.ofbiz.core.service.GenericRequester;
import org.ofbiz.core.service.GenericResultWaiter;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.ModelService;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.util.Debug;

public class GenericDispatcher
extends GenericAbstractDispatcher {
    public static final String module = GenericDispatcher.class.getName();

    public GenericDispatcher() {
    }

    public GenericDispatcher(String name, GenericDelegator delegator) {
        this(name, delegator, null);
    }

    public GenericDispatcher(String name, GenericDelegator delegator, ClassLoader loader) {
        if (loader == null) {
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException e) {
                loader = this.getClass().getClassLoader();
            }
        }
        DispatchContext dc = new DispatchContext(name, null, loader, null);
        this.init(name, delegator, dc);
    }

    public GenericDispatcher(DispatchContext ctx, GenericDelegator delegator) {
        this.init(ctx.getName(), delegator, ctx);
    }

    public GenericDispatcher(DispatchContext ctx, ServiceDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        this.ctx = ctx;
        this.name = ctx.getName();
        ctx.setDispatcher(this);
        dispatcher.register(this.name, ctx);
    }

    protected void init(String name, GenericDelegator delegator, DispatchContext ctx) {
        if (name == null && name.length() == 0) {
            throw new IllegalArgumentException("The name of a LocalDispatcher cannot be a null or empty String");
        }
        this.name = name;
        this.ctx = ctx;
        this.dispatcher = ServiceDispatcher.getInstance(name, ctx, delegator);
        ctx.setDispatcher(this);
        if (Debug.infoOn()) {
            Debug.logInfo((String)("[LocalDispatcher] : Created Dispatcher for: " + name), (String)module);
        }
    }

    public Map runSync(String serviceName, Map context) throws GenericServiceException {
        ModelService service = this.ctx.getModelService(serviceName);
        return this.dispatcher.runSync(this.name, service, context);
    }

    public void runSyncIgnore(String serviceName, Map context) throws GenericServiceException {
        ModelService service = this.ctx.getModelService(serviceName);
        this.dispatcher.runSyncIgnore(this.name, service, context);
    }

    public void runAsync(String serviceName, Map context, GenericRequester requester, boolean persist) throws GenericServiceException {
        ModelService service = this.ctx.getModelService(serviceName);
        this.dispatcher.runAsync(this.name, service, context, requester, persist);
    }

    public void runAsync(String serviceName, Map context, GenericRequester requester) throws GenericServiceException {
        this.runAsync(serviceName, context, requester, true);
    }

    public void runAsync(String serviceName, Map context, boolean persist) throws GenericServiceException {
        ModelService service = this.ctx.getModelService(serviceName);
        this.dispatcher.runAsync(this.name, service, context, persist);
    }

    public void runAsync(String serviceName, Map context) throws GenericServiceException {
        this.runAsync(serviceName, context, true);
    }

    public GenericResultWaiter runAsyncWait(String serviceName, Map context, boolean persist) throws GenericServiceException {
        GenericResultWaiter waiter = new GenericResultWaiter();
        this.runAsync(serviceName, context, waiter, persist);
        return waiter;
    }

    public GenericResultWaiter runAsyncWait(String serviceName, Map context) throws GenericServiceException {
        return this.runAsyncWait(serviceName, context, true);
    }
}

