/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.service;

import java.util.Date;
import java.util.Map;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.security.Security;
import org.ofbiz.core.service.DispatchContext;
import org.ofbiz.core.service.GenericRequester;
import org.ofbiz.core.service.GenericResultWaiter;
import org.ofbiz.core.service.GenericServiceException;
import org.ofbiz.core.service.LocalDispatcher;
import org.ofbiz.core.service.ServiceDispatcher;
import org.ofbiz.core.service.jms.JmsListenerFactory;
import org.ofbiz.core.service.job.JobManager;
import org.ofbiz.core.service.job.JobManagerException;
import org.ofbiz.core.util.Debug;

public abstract class GenericAbstractDispatcher
implements LocalDispatcher {
    public static final String module = GenericAbstractDispatcher.class.getName();
    protected DispatchContext ctx = null;
    protected ServiceDispatcher dispatcher = null;
    protected String name = null;

    public abstract Map runSync(String var1, Map var2) throws GenericServiceException;

    public abstract void runSyncIgnore(String var1, Map var2) throws GenericServiceException;

    public abstract void runAsync(String var1, Map var2, GenericRequester var3, boolean var4) throws GenericServiceException;

    public abstract void runAsync(String var1, Map var2, GenericRequester var3) throws GenericServiceException;

    public abstract void runAsync(String var1, Map var2, boolean var3) throws GenericServiceException;

    public abstract void runAsync(String var1, Map var2) throws GenericServiceException;

    public abstract GenericResultWaiter runAsyncWait(String var1, Map var2, boolean var3) throws GenericServiceException;

    public abstract GenericResultWaiter runAsyncWait(String var1, Map var2) throws GenericServiceException;

    public void schedule(String serviceName, Map context, long startTime, int frequency, int interval, int count, long endTime) throws GenericServiceException {
        try {
            this.getJobManager().schedule(this.getName(), serviceName, context, startTime, frequency, interval, count, endTime);
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)("[LocalDispatcher.schedule] : Current time: " + new Date().getTime()), (String)module);
                Debug.logVerbose((String)("[LocalDispatcher.schedule] : Runtime: " + startTime), (String)module);
                Debug.logVerbose((String)("[LocalDispatcher.schedule] : Frequency: " + frequency), (String)module);
                Debug.logVerbose((String)("[LocalDispatcher.schedule] : Interval: " + interval), (String)module);
                Debug.logVerbose((String)("[LocalDispatcher.schedule] : Count: " + count), (String)module);
                Debug.logVerbose((String)("[LocalDispatcher.schedule] : EndTime: " + endTime), (String)module);
            }
        }
        catch (JobManagerException e) {
            throw new GenericServiceException(e.getMessage(), (Throwable)((Object)e));
        }
    }

    public void schedule(String serviceName, Map context, long startTime, int frequency, int interval, int count) throws GenericServiceException {
        this.schedule(serviceName, context, startTime, frequency, interval, count, 0L);
    }

    public void schedule(String serviceName, Map context, long startTime, int frequency, int interval, long endTime) throws GenericServiceException {
        this.schedule(serviceName, context, startTime, frequency, interval, -1, endTime);
    }

    public void schedule(String serviceName, Map context, long startTime) throws GenericServiceException {
        this.schedule(serviceName, context, startTime, 4, 1, 1);
    }

    public JobManager getJobManager() {
        return this.dispatcher.getJobManager();
    }

    public JmsListenerFactory getJMSListeneFactory() {
        return this.dispatcher.getJMSListenerFactory();
    }

    public GenericDelegator getDelegator() {
        return this.dispatcher.getDelegator();
    }

    public Security getSecurity() {
        return this.dispatcher.getSecurity();
    }

    public String getName() {
        return this.name;
    }

    public DispatchContext getDispatchContext() {
        return this.ctx;
    }

    public void deregister() {
        this.dispatcher.deregister(this);
    }
}

