/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.security;

import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.SecurityConfigUtil;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.security.Security;
import org.ofbiz.core.security.SecurityConfigurationException;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilProperties;
import org.ofbiz.core.util.UtilValidate;
import org.w3c.dom.Element;

public class SecurityFactory {
    public static final String module = SecurityFactory.class.getName();
    public static final String DEFAULT_SECURITY = "org.ofbiz.core.security.OFBizSecurity";
    private static String securityName = null;
    private static Element rootElement = null;
    private static SecurityConfigUtil.SecurityInfo securityInfo = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Security getInstance(GenericDelegator delegator) throws SecurityConfigurationException {
        Security security = null;
        if (securityName == null) {
            String _securityName;
            securityName = _securityName = UtilProperties.getPropertyValue((String)"security.properties", (String)"security.context");
        }
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[SecurityFactory.getInstance] Security implementation context name from security.properties: " + securityName), (String)module);
        }
        Class<SecurityFactory> clazz = SecurityFactory.class;
        synchronized (SecurityFactory.class) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> c = loader.loadClass(SecurityFactory.getSecurityClass(securityName));
                security = (Security)c.newInstance();
                security.setDelegator(delegator);
            }
            catch (ClassNotFoundException cnf) {
                throw new SecurityConfigurationException("Cannot load security implementation class", cnf);
            }
            catch (InstantiationException ie) {
                throw new SecurityConfigurationException("Cannot get instance of the security implementation", ie);
            }
            catch (IllegalAccessException iae) {
                throw new SecurityConfigurationException(iae.getMessage(), iae);
            }
            if (Debug.verboseOn()) {
                Debug.logVerbose((String)"[SecurityFactory.getInstance] Security implementation successfully loaded!!!", (String)module);
            }
            return security;
        }
    }

    private static String getSecurityClass(String securityName) throws SecurityConfigurationException {
        String className = null;
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[SecurityFactory.getSecurityClass] Security implementation context name: " + securityName), (String)module);
        }
        if (rootElement == null) {
            try {
                Element _rootElement;
                SecurityConfigUtil.getXmlDocument();
                rootElement = _rootElement = SecurityConfigUtil.getXmlRootElement();
            }
            catch (GenericConfigException e) {
                Debug.logError((Throwable)e, (String)"Error getting Security Config XML root element", (String)module);
                return null;
            }
        }
        if (securityInfo == null) {
            SecurityConfigUtil.SecurityInfo _securityInfo = SecurityConfigUtil.getSecurityInfo((String)securityName);
            if (_securityInfo == null) {
                throw new SecurityConfigurationException("ERROR: no security definition was found with the name " + securityName + " in security.xml");
            }
            securityInfo = _securityInfo;
        }
        className = UtilValidate.isEmpty((String)SecurityFactory.securityInfo.className) ? DEFAULT_SECURITY : SecurityFactory.securityInfo.className;
        if (Debug.verboseOn()) {
            Debug.logVerbose((String)("[SecurityFactory.getSecurity] Security implementation " + className + " for security name " + securityName + " successfully loaded!!!"), (String)module);
        }
        return className;
    }
}

