/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gadgets;

import java.util.Locale;

public final class GadgetRequestContext {
    public static final GadgetRequestContext NO_CURRENT_REQUEST = Builder.gadgetRequestContext().locale(new Locale("")).ignoreCache(false).debug(false).build();
    private final Locale locale;
    private final boolean ignoreCache;
    private final String viewer;
    private final boolean debug;

    private GadgetRequestContext(Builder builder) {
        this.locale = builder.locale;
        this.ignoreCache = builder.ignoreCache;
        this.viewer = builder.viewer;
        this.debug = builder.debug;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean getIgnoreCache() {
        return this.ignoreCache;
    }

    public String getViewer() {
        return this.viewer;
    }

    public boolean isDebuggingEnabled() {
        return this.debug;
    }

    public static class Builder {
        private Locale locale = Locale.US;
        private boolean ignoreCache = false;
        private String viewer = null;
        private boolean debug = false;

        public static Builder gadgetRequestContext() {
            return new Builder();
        }

        public GadgetRequestContext build() {
            return new GadgetRequestContext(this);
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder ignoreCache(boolean ignoreCache) {
            this.ignoreCache = ignoreCache;
            return this;
        }

        public Builder viewer(String viewer) {
            this.viewer = viewer;
            return this;
        }

        public Builder debug(boolean debug) {
            this.debug = debug;
            return this;
        }
    }
}

