/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

public class FileNameCharacterCheckerUtil {
    public static final char[] INVALID_CHARS = new char[]{'\\', '/', '\"', ':', '?', '*', '<', '|', '>'};

    public String assertFileNameDoesNotContainInvalidChars(String filename) {
        if (filename == null) {
            return null;
        }
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            char invalidChar = INVALID_CHARS[i];
            if (filename.indexOf(invalidChar) == -1) continue;
            return String.valueOf(invalidChar);
        }
        return null;
    }

    public String replaceInvalidChars(String filename, char replacementChar) {
        if (this.assertFileNameDoesNotContainInvalidChars(String.valueOf(replacementChar)) != null) {
            throw new IllegalArgumentException("Replacement character '" + replacementChar + "' is invalid");
        }
        if (filename == null) {
            return null;
        }
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            char invalidChar = INVALID_CHARS[i];
            filename = filename.replace(invalidChar, replacementChar);
        }
        return filename;
    }

    public String getPrintableInvalidCharacters() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < INVALID_CHARS.length; ++i) {
            char invalidChar = INVALID_CHARS[i];
            sb.append("'");
            sb.append(invalidChar);
            sb.append("'");
            if (i + 1 >= INVALID_CHARS.length) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

