/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.CommitException;
import com.perforce.api.HashDecay;
import com.perforce.api.SourceControlObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Mapping
extends SourceControlObject
implements Comparable {
    private String name = "";
    private String owner = "";
    private String description = "";
    private final Hashtable views = new Hashtable();
    private final Vector view_list = new Vector();

    public Mapping() {
    }

    public Mapping(String name) {
        this();
        this.setName(name);
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((Mapping)o).getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        HashDecay mappings;
        HashDecay hashDecay = mappings = this.getCache();
        synchronized (hashDecay) {
            mappings.remove(this.name);
            this.name = name;
            if (null != name && !name.trim().equals("")) {
                mappings.put((Object)this.name, this);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void addView(String from, String to) {
        this.views.put(from, to);
        if (null == to) {
            this.view_list.addElement(from);
        } else {
            this.view_list.addElement(from + " " + to);
        }
    }

    public void addView(String line) {
        int from = (line = line.trim()).indexOf("//");
        if (-1 == from) {
            return;
        }
        int to = line.lastIndexOf("//");
        if (-1 == to) {
            return;
        }
        if (from == to) {
            this.addView(line.substring(0, to).trim(), null);
        } else {
            this.addView(line.substring(0, to).trim(), line.substring(to - 1).trim());
        }
    }

    public synchronized String getView() {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.views.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = (String)this.views.get(key);
            sb.append('\t');
            sb.append(key);
            if (null != val) {
                sb.append(' ');
                sb.append(val);
            }
            sb.append('\n');
        }
        return sb.toString();
    }

    public Enumeration getViews() {
        return this.view_list.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration lookupMappings(HashDecay mappings, String prefix) {
        Vector<String> v = new Vector<String>();
        HashDecay hashDecay = mappings;
        synchronized (hashDecay) {
            Enumeration en = mappings.keys();
            while (en.hasMoreElements()) {
                String key = (String)en.nextElement();
                if (!key.startsWith(prefix)) continue;
                v.addElement(key);
            }
        }
        return v.elements();
    }

    public String toString() {
        return this.name;
    }

    public abstract void commit() throws CommitException;

    public abstract void sync(String var1);

    public String toXML() {
        StringBuffer sb = new StringBuffer("<mappings>");
        Enumeration en = this.views.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = (String)this.views.get(key);
            sb.append("<map><from>");
            sb.append(key);
            sb.append("</from>");
            if (null != val) {
                sb.append("<to>");
                sb.append(val);
                sb.append("</to>");
            }
            sb.append("</map>");
        }
        sb.append("</mappings>");
        return sb.toString();
    }
}

