/*
 * Decompiled with CFR 0.152.
 */
package com.perforce.api;

import com.perforce.api.CommitException;
import com.perforce.api.Debug;
import com.perforce.api.Env;
import com.perforce.api.FileEntry;
import com.perforce.api.HashDecay;
import com.perforce.api.P4Process;
import com.perforce.api.PerforceException;
import com.perforce.api.SourceControlObject;
import com.perforce.api.SubmitException;
import com.perforce.api.User;
import com.perforce.api.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Change
extends SourceControlObject {
    private int number = -1;
    private User user = null;
    private String client_name = "";
    private String modtime_string = "";
    private String description = "";
    private int status = 1;
    private static HashDecay changes = null;
    public static final int PENDING = 1;
    public static final int SUBMITTED = 2;

    public Change() {
        this.getCache();
    }

    public Change(Env environ) {
        this();
        this.setEnv(environ);
    }

    public Change(int number) {
        this();
        this.number = number;
    }

    public Change(String number) {
        this();
        this.number = Integer.valueOf(number);
    }

    private static HashDecay setCache() {
        if (null == changes) {
            changes = new HashDecay(300000L);
            changes.start();
        }
        return changes;
    }

    public HashDecay getCache() {
        return Change.setCache();
    }

    public static Change getChange(String number) {
        return Change.getChange(null, number, true);
    }

    public static Change getChange(String number, boolean force) {
        return Change.getChange(null, number, force);
    }

    public static Change getChange(Env env, String number, boolean force) {
        return Change.getChange(env, Integer.valueOf(number), force);
    }

    public static Change getChange(int number) {
        return Change.getChange(null, number, true);
    }

    public static Change getChange(int number, boolean force) {
        return Change.getChange(null, number, force);
    }

    public static Change getChange(Env env, int number, boolean force) {
        Change c = (Change)Change.setCache().get(new Integer(number));
        if (null == c) {
            c = new Change(number);
            force = true;
        }
        if (null != env) {
            c.setEnv(env);
        }
        if (force) {
            c.sync();
        }
        changes.put((Object)new Integer(number), c);
        return c;
    }

    public String getClientName() {
        return this.client_name;
    }

    public void setClientName(String name) {
        this.client_name = name;
    }

    public String getModtimeString() {
        return this.modtime_string;
    }

    public void setModtimeString(String modtime) {
        this.modtime_string = modtime;
    }

    public void setNumber(int number) {
        this.number = number;
        this.user = null;
        this.description = "";
        this.status = 1;
    }

    public int getNumber() {
        return this.number;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public User getUser() {
        return this.user;
    }

    public void setDescription(String description) {
        try {
            String l;
            StringBuffer sb = new StringBuffer();
            BufferedReader b = new BufferedReader(new StringReader(description));
            while (null != (l = b.readLine())) {
                sb.append('\t');
                sb.append(l.trim());
                sb.append('\n');
            }
            this.description = sb.toString();
        }
        catch (IOException ex) {
            this.description = description;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public String getShortDescription() {
        return this.getShortDescription(false);
    }

    public String getShortDescription(boolean blurb) {
        StringBuffer sb = new StringBuffer();
        try {
            String l;
            BufferedReader b = new BufferedReader(new StringReader(this.getDescription()));
            while (null != (l = b.readLine())) {
                if (blurb && l.startsWith("Change")) continue;
                if (!(blurb && l.startsWith("Jobs fixed") || l.startsWith("Affected file"))) {
                    sb.append(l);
                    sb.append('\n');
                    continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return sb.toString();
    }

    public Vector getFiles() {
        Vector<String> v = new Vector<String>();
        try {
            String l;
            BufferedReader b = new BufferedReader(new StringReader(this.getDescription()));
            while (null != (l = b.readLine())) {
                int pos;
                String t = l.trim();
                if (!t.startsWith("//") || -1 == (pos = t.lastIndexOf(" "))) continue;
                v.addElement(t.substring(0, pos).trim());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return v;
    }

    public Vector getFileEntries() {
        if (1 == this.getStatus() && 0 < this.getNumber()) {
            return FileEntry.getOpened(this.getEnv(), false, false, this.getNumber(), null);
        }
        Vector<FileEntry> v = new Vector<FileEntry>();
        try {
            String l;
            BufferedReader b = new BufferedReader(new StringReader(this.getDescription()));
            while (null != (l = b.readLine())) {
                String t = l.trim();
                if (!t.startsWith("//")) continue;
                FileEntry fent = new FileEntry();
                fent.setEnv(this.getEnv());
                int beg = 0;
                int end = 4;
                end = t.indexOf(35, beg);
                if (-1 != end) {
                    fent.setDepotPath(t.substring(beg, end));
                    beg = end + 1;
                    end = t.indexOf(32, beg);
                    if (-1 != end) {
                        fent.setHeadRev(Integer.valueOf(t.substring(beg, end).trim()));
                        fent.setHeadAction(t.substring(end + 1));
                    }
                } else {
                    fent.setDepotPath(t);
                }
                v.addElement(fent);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return v;
    }

    public void addFile(FileEntry fent) throws PerforceException {
        if (-1 == this.number) {
            this.commit();
        }
        fent.reopen(null, this);
    }

    public String resolve(boolean force) throws PerforceException {
        StringBuffer sb = new StringBuffer();
        Enumeration en = this.getFileEntries().elements();
        try {
            while (en.hasMoreElements()) {
                sb.append(((FileEntry)en.nextElement()).resolve(force));
            }
        }
        catch (Exception ex) {
            throw new PerforceException(ex);
        }
        return sb.toString();
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public String submit() throws SubmitException {
        StringBuffer sb = new StringBuffer();
        if (1 != this.status) {
            throw new SubmitException("Change already submitted.");
        }
        String[] cmd = new String[]{"p4", "submit", "-c", String.valueOf(this.getNumber())};
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                sb.append(l);
                sb.append('\n');
            }
            p.closeProcess();
        }
        catch (Exception ex) {
            throw new SubmitException(ex + ": " + sb.toString(), ex);
        }
        return sb.toString();
    }

    public void store() throws CommitException {
        this.commit();
    }

    public void commit() throws CommitException {
        Vector fents = this.getFileEntries();
        StringBuffer sb = new StringBuffer();
        String[] cmd = new String[]{"p4", "change", "-i"};
        boolean store_failed = false;
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException intex) {
                // empty catch block
            }
            if (0 > this.number) {
                p.println("Change: new");
            } else {
                p.println("Change: " + this.getNumber());
            }
            p.println("Client: " + this.getClientName());
            if (null == this.getUser() && null != this.getEnv()) {
                p.println("User: " + this.getEnv().getUser());
            } else {
                p.println("User: " + this.user.getId());
            }
            p.println("Description: ");
            p.println(this.getDescription());
            if (null != fents && 0 < fents.size()) {
                p.println("Files: ");
                Enumeration en = fents.elements();
                while (en.hasMoreElements()) {
                    FileEntry fent = (FileEntry)en.nextElement();
                    p.println("\t" + fent.getDepotPath());
                }
            }
            if (Utils.isWindows()) {
                p.println("\u001a\n\u001a");
            }
            p.flush();
            p.outClose();
            Debug.notify("Change.store(): Wrote change info.");
            while (null != (l = p.readLine())) {
                int pos;
                Debug.notify("READ: " + l);
                if (l.startsWith("Change ") && -1 != (pos = l.indexOf("created"))) {
                    this.setNumber(Integer.valueOf(l.substring(7, pos - 1).trim()));
                }
                if (l.startsWith("Error")) {
                    store_failed = true;
                }
                sb.append(l);
                sb.append('\n');
            }
            p.closeProcess();
            Debug.notify("Change.store(): All done reading.");
        }
        catch (Exception ex) {
            throw new CommitException(ex);
        }
        if (store_failed || 0 > this.getNumber()) {
            throw new CommitException(sb.toString());
        }
    }

    public void sync() {
        this.sync(this.number);
    }

    public void sync(int number) {
        if (2 == this.status && !this.outOfSync(60000L)) {
            return;
        }
        this.number = number;
        String[] cmd = new String[]{"p4", "describe", "-s", "number"};
        cmd[3] = String.valueOf(number);
        boolean wasFound = false;
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            StringBuffer buffer = new StringBuffer();
            while (null != (l = p.readLine())) {
                if (!wasFound && l.startsWith("Change")) {
                    String tstr = l.substring(l.indexOf("by") + 3).trim();
                    tstr = tstr.substring(0, tstr.indexOf("@"));
                    this.user = User.getUser(this.getEnv(), tstr);
                    this.modtime_string = l.substring(l.indexOf(" on ") + 4).trim();
                    if (-1 == l.indexOf("pending")) {
                        this.status = 2;
                    }
                    wasFound = true;
                    buffer.append(l);
                    continue;
                }
                buffer.append(l.trim());
                buffer.append("\n");
            }
            this.description = buffer.toString();
            p.closeProcess();
            this.inSync();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
    }

    public void revert() throws PerforceException {
        if (1 != this.status) {
            throw new PerforceException("Change already submitted.");
        }
        Enumeration en = this.getFileEntries().elements();
        try {
            while (en.hasMoreElements()) {
                ((FileEntry)en.nextElement()).revert();
            }
        }
        catch (Exception ex) {
            throw new PerforceException(ex);
        }
    }

    public String delete() throws PerforceException {
        this.revert();
        StringBuffer sb = new StringBuffer();
        if (1 != this.status) {
            throw new PerforceException("Change already submitted.");
        }
        String[] cmd = new String[]{"p4", "change", "-d", String.valueOf(this.getNumber())};
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                sb.append(l);
                sb.append('\n');
            }
            p.closeProcess();
        }
        catch (Exception ex) {
            throw new PerforceException(ex + ": " + sb.toString(), ex);
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Change: ");
        sb.append(this.number);
        sb.append("\nUser: ");
        sb.append(this.user);
        sb.append("\nDescription:\n");
        sb.append(this.description);
        return sb.toString();
    }

    public static Change[] getChanges(Env env, String path) throws PerforceException {
        return Change.getChanges(env, path, 100, null, null, false, null);
    }

    public static Change[] getChanges(String path) throws PerforceException {
        return Change.getChanges(null, path, 100, null, null, false, null);
    }

    public static Change[] getChanges(Env env, String path, int max, String start, String end, boolean use_integs, String ufilter) throws PerforceException {
        int cmdlen = 8;
        String tpath = path;
        if (use_integs) {
            ++cmdlen;
        }
        if (null == tpath) {
            tpath = "";
        }
        if (null != start && !start.trim().equals("")) {
            tpath = tpath + "@" + start;
            if (null != end && !end.trim().equals("")) {
                tpath = tpath + "," + end;
            }
        }
        if (tpath.trim().equals("")) {
            --cmdlen;
        }
        String[] cmd = new String[cmdlen];
        if (!tpath.trim().equals("")) {
            cmd[cmdlen - 1] = tpath;
        }
        cmd[0] = "p4";
        cmd[1] = "changes";
        cmd[2] = "-m";
        cmd[3] = String.valueOf(max);
        cmd[4] = "-l";
        cmd[5] = "-s";
        cmd[6] = "submitted";
        if (use_integs) {
            cmd[7] = "-i";
        }
        Vector<Change> v = new Vector<Change>();
        String description = "";
        Change c = null;
        try {
            String l;
            P4Process p = new P4Process(env);
            p.setRawMode(true);
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (l.startsWith("info: Change")) {
                    int num;
                    StringTokenizer st = new StringTokenizer(l = l.substring(6).trim());
                    if (!st.nextToken().equals("Change")) continue;
                    try {
                        num = Integer.parseInt(st.nextToken());
                    }
                    catch (Exception ex) {
                        throw new PerforceException("Could not parse change number from line: " + l, ex);
                    }
                    if (!st.nextToken().equals("on")) continue;
                    String modtime = st.nextToken();
                    if (!st.nextToken().equals("by")) continue;
                    String id = st.nextToken();
                    int pos = id.indexOf("@");
                    String client_name = id.substring(pos + 1);
                    id = id.substring(0, pos);
                    User user = User.getUser(env, id);
                    if (null != c) {
                        c.setDescription(description);
                    }
                    description = "";
                    c = new Change(num);
                    c.setEnv(env);
                    c.setUser(user);
                    c.setClientName(client_name);
                    c.setModtimeString(modtime);
                    if (null != ufilter && !id.equals(ufilter)) continue;
                    v.addElement(c);
                    continue;
                }
                l = l.substring(5).trim();
                description = description + l + "\n";
            }
            if (null != c) {
                c.setDescription(description);
            }
            p.closeProcess();
        }
        catch (IOException ex) {
            Debug.out(1, ex);
        }
        Change[] chngs = new Change[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            chngs[i] = (Change)v.elementAt(i);
            changes.put((Object)new Integer(chngs[i].getNumber()), chngs[i]);
        }
        return chngs;
    }

    public String toXML() {
        StringBuffer sb = new StringBuffer("<change number=\"");
        sb.append(this.getNumber());
        sb.append("\" user=\"");
        sb.append(this.getUser());
        sb.append("\" client=\"");
        sb.append(this.getClientName());
        sb.append("\" status=\"");
        sb.append(this.getStatus());
        sb.append("\" modtime=\"");
        sb.append(this.getModtimeString());
        sb.append("\">");
        sb.append("<description>");
        sb.append(this.getDescription());
        sb.append("</description>");
        Vector v = this.getFileEntries();
        FileEntry fent = null;
        if (null != v && 0 != v.size()) {
            sb.append("<files>");
            for (int i = 0; i < v.size(); ++i) {
                fent = (FileEntry)v.elementAt(i);
                sb.append("<file path=\"");
                sb.append(fent.getDepotPath());
                sb.append("\" rev=\"");
                sb.append(fent.getHeadRev());
                sb.append("\"/>");
            }
            sb.append("</files>");
        }
        sb.append("</change>");
        return sb.toString();
    }

    public User[] reviews() throws PerforceException {
        Vector<User> users = new Vector<User>();
        User[] usrs = new User[]{};
        String[] cmd = new String[]{"p4", "reviews", "-c", String.valueOf(this.number)};
        try {
            String l;
            P4Process p = new P4Process(this.getEnv());
            p.exec(cmd);
            while (null != (l = p.readLine())) {
                if (l.length() < 4) continue;
                StringTokenizer st = new StringTokenizer(l);
                String uid = st.nextToken();
                String email = st.nextToken("<> \t");
                String name = st.nextToken("<> ()\t");
                try {
                    String t;
                    while (null != (t = st.nextToken("<> ()\t"))) {
                        name = name + " " + t;
                    }
                }
                catch (NoSuchElementException ex) {
                    // empty catch block
                }
                User usr = new User(uid);
                usr.setEnv(this.getEnv());
                usr.setEmail(email);
                usr.setFullName(name);
                users.addElement(usr);
            }
            p.closeProcess();
        }
        catch (Exception ex) {
            throw new PerforceException(ex);
        }
        if (0 == users.size()) {
            return null;
        }
        return users.toArray(usrs);
    }

    public static void main(String[] args) {
        String propfile = "/etc/p4.conf";
        Env environ = null;
        Debug.setDebugLevel(99);
        if (0 < args.length) {
            propfile = args[0];
        }
        try {
            environ = new Env(propfile);
        }
        catch (PerforceException ex) {
            System.out.println("Could not load properties from " + propfile + ": " + ex);
            System.exit(-1);
        }
        System.out.println(environ);
        Change chng = new Change(environ);
        chng.setDescription("This is a test changelist.");
        try {
            chng.commit();
        }
        catch (CommitException e) {
            System.err.println("Unable to store new change.");
            e.printStackTrace(System.err);
            System.exit(-1);
        }
        System.out.println("New Changelist Generated: " + chng.getNumber());
        Utils.cleanUp();
    }
}

