/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.seraph.config;

import com.atlassian.seraph.config.RedirectPolicy;
import com.atlassian.seraph.config.SecurityConfig;
import com.atlassian.seraph.util.RedirectUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultRedirectPolicy
implements RedirectPolicy {
    private boolean allowAnyUrl = false;

    @Override
    public void init(Map<String, String> params, SecurityConfig config) {
        if (params == null) {
            throw new IllegalArgumentException("params is not allowed to be null");
        }
        this.allowAnyUrl = "true".equals(params.get("allow.any.redirect.url"));
    }

    public boolean isAllowAnyUrl() {
        return this.allowAnyUrl;
    }

    @Override
    public boolean allowedRedirectDestination(String redirectUrl, HttpServletRequest request) {
        URI uri;
        if (this.allowAnyUrl) {
            return true;
        }
        try {
            uri = new URI(redirectUrl);
        }
        catch (URISyntaxException e) {
            return false;
        }
        return !uri.isAbsolute() || RedirectUtils.sameContext(redirectUrl, request);
    }
}

