/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.renderer;

import java.awt.Color;
import java.awt.Paint;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.Commit;
import net.sf.statcvs.model.CvsContent;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.output.ConfigurationOptions;
import net.sf.statcvs.renderer.Chart;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.Legend;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.CategoryItemRenderer;
import org.jfree.data.CategoryDataset;
import org.jfree.data.DefaultCategoryDataset;

public class StackedBarChart
extends Chart {
    private static final int MODIFYING = 0;
    private static final int ADDING = 1;
    private CvsContent content;
    private double[][] categories;
    private ArrayList categoryNames = new ArrayList();

    public StackedBarChart(CvsContent content, String title, String fileName) {
        super(title, fileName);
        this.content = content;
        SortedSet authors = content.getAuthors();
        Iterator it = authors.iterator();
        while (it.hasNext()) {
            Author author = (Author)it.next();
            this.categoryNames.add(author.getName());
        }
        Collections.sort(this.categoryNames);
        this.categories = new double[2][this.categoryNames.size()];
        for (int j = 0; j < this.categoryNames.size(); ++j) {
            this.categories[0][j] = 0.0;
            this.categories[1][j] = 0.0;
        }
        Iterator commitIt = content.getCommits().iterator();
        while (commitIt.hasNext()) {
            Commit commit = (Commit)commitIt.next();
            Set commitRevList = commit.getRevisions();
            Iterator commitRevIt = commitRevList.iterator();
            String authorName = commit.getAuthor().getName();
            if (authorName == null) continue;
            int author = this.categoryNames.indexOf(authorName);
            int linesAdded = 0;
            int linesRemoved = 0;
            while (commitRevIt.hasNext()) {
                CvsRevision revision = (CvsRevision)commitRevIt.next();
                if (revision.getLinesDelta() > 0) {
                    linesAdded += revision.getLinesDelta() + revision.getReplacedLines();
                    linesRemoved += revision.getReplacedLines();
                    continue;
                }
                linesAdded += revision.getReplacedLines();
                linesRemoved += -revision.getLinesDelta() + revision.getReplacedLines();
            }
            if (linesAdded == linesRemoved) {
                double[] dArray = this.categories[0];
                int n = author;
                dArray[n] = dArray[n] + (double)linesAdded;
            }
            if (linesAdded < linesRemoved) {
                double[] dArray = this.categories[0];
                int n = author;
                dArray[n] = dArray[n] + (double)linesRemoved;
            }
            if (linesAdded <= linesRemoved) continue;
            double[] dArray = this.categories[1];
            int n = author;
            dArray[n] = dArray[n] + (double)(linesAdded - linesRemoved);
            double[] dArray2 = this.categories[0];
            int n2 = author;
            dArray2[n2] = dArray2[n2] + (double)linesRemoved;
        }
        for (int i = 0; i < authors.size(); ++i) {
            double maxLines = this.categories[0][i] + this.categories[1][i];
            for (int k = 0; k < 2; ++k) {
                double[] dArray = this.categories[k];
                int n = i;
                dArray[n] = dArray[n] * (100.0 / maxLines);
            }
        }
        this.createStackedBarChart();
    }

    private void createStackedBarChart() {
        DefaultCategoryDataset data = new DefaultCategoryDataset();
        for (int i = 0; i < this.categories[0].length; ++i) {
            data.addValue(this.categories[0][i], (Comparable)((Object)"modifying"), (Comparable)this.categoryNames.get(i));
        }
        for (int j = 0; j < this.categories[1].length; ++j) {
            data.addValue(this.categories[1][j], (Comparable)((Object)"adding"), (Comparable)this.categoryNames.get(j));
        }
        this.setChart(ChartFactory.createStackedBarChart((String)ConfigurationOptions.getProjectName(), (String)"", (String)"%", (CategoryDataset)data, (PlotOrientation)PlotOrientation.HORIZONTAL, (boolean)true, (boolean)false, (boolean)false));
        CategoryPlot plot = this.getChart().getCategoryPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, (Paint)Color.yellow);
        renderer.setSeriesPaint(1, (Paint)Color.green);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setTickUnit(new NumberTickUnit(20.0, (NumberFormat)new DecimalFormat("0")));
        rangeAxis.setUpperBound(100.0);
        Legend legend = this.getChart().getLegend();
        legend.setAnchor(1);
        this.createChart();
        this.saveChart(450, 19 * this.content.getAuthors().size() + 110, "activity.png");
    }
}

