/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Date;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsBranch;
import net.sf.statcvs.model.CvsFile;

public class CvsRevision
implements Comparable {
    public static final int TYPE_CREATION = 1;
    public static final int TYPE_CHANGE = 2;
    public static final int TYPE_DELETION = 3;
    public static final int TYPE_BEGIN_OF_LOG = 5;
    private final CvsFile file;
    private final String revisionNumber;
    private final int type;
    private final Author author;
    private final Date date;
    private final String comment;
    private final int lines;
    private final int linesReplaced;
    private final int linesDelta;
    private final CvsBranch mainBranch;
    private CvsRevision previousRevision;

    CvsRevision(CvsFile file, CvsBranch mainBranch, String revisionNumber, int type, Author author, Date date, String comment, int lines, int linesDelta, int linesReplaced) {
        this.file = file;
        this.mainBranch = mainBranch;
        this.revisionNumber = revisionNumber;
        this.type = type;
        this.author = author;
        this.date = date;
        this.comment = comment;
        this.lines = lines;
        this.linesDelta = linesDelta;
        this.linesReplaced = linesReplaced;
        if (author != null) {
            author.addRevision(this);
        }
    }

    public String getRevisionNumber() {
        return this.revisionNumber;
    }

    public Author getAuthor() {
        return this.author;
    }

    public String getComment() {
        return this.comment;
    }

    public Date getDate() {
        return this.date;
    }

    public int getLines() {
        return this.lines;
    }

    public int getLinesDelta() {
        return this.linesDelta;
    }

    public int getReplacedLines() {
        return this.linesReplaced;
    }

    public int getNewLines() {
        if (this.getLinesDelta() > 0) {
            return this.getLinesDelta() + this.getReplacedLines();
        }
        return this.getReplacedLines();
    }

    public int getFileCountDelta() {
        if (this.isInitialRevision()) {
            return 1;
        }
        if (this.isDead()) {
            return -1;
        }
        return 0;
    }

    public boolean isInitialRevision() {
        return this.type == 1;
    }

    public boolean isDead() {
        return this.type == 3;
    }

    public boolean isBeginOfLog() {
        return this.type == 5;
    }

    public String toString() {
        return this.author.getName() + " - " + this.revisionNumber;
    }

    public CvsFile getFile() {
        return this.file;
    }

    public CvsBranch getMainBranch() {
        return this.mainBranch;
    }

    public CvsRevision getPreviousRevision() {
        return this.previousRevision;
    }

    public void setPreviousRevision(CvsRevision previousRevision) {
        this.previousRevision = previousRevision;
    }

    public int compareTo(Object other) {
        if (this == other) {
            return 0;
        }
        CvsRevision otherRevision = (CvsRevision)other;
        int result = this.date.compareTo(otherRevision.getDate());
        if (result != 0) {
            return result;
        }
        result = this.file.getFilenameWithPath().compareTo(otherRevision.getFile().getFilenameWithPath());
        if (result != 0) {
            return result;
        }
        result = this.revisionNumber.compareTo(otherRevision.getRevisionNumber());
        if (result != 0) {
            return result;
        }
        if (this.author != null && otherRevision.getAuthor() != null && (result = this.author.compareTo(otherRevision.getAuthor())) != 0) {
            return result;
        }
        if (this.comment != null && otherRevision.getComment() != null) {
            return this.comment.compareTo(otherRevision.getComment());
        }
        return 1;
    }

    public int getLinesAdded() {
        if (this.isInitialRevision() && this.getPreviousRevision() != null) {
            return 0;
        }
        return this.getNewLines();
    }

    public int getLinesRemoved() {
        if (this.isDead()) {
            return 0;
        }
        if (this.getLinesDelta() < 0) {
            return -this.getLinesDelta() + this.getReplacedLines();
        }
        return this.getReplacedLines();
    }

    public int getLinesOfCode() {
        if (this.isDead() && this.getPreviousRevision() != null) {
            return this.getPreviousRevision().getLines();
        }
        return this.getLines();
    }

    public int getEffectiveLinesOfCode() {
        return this.getLines();
    }

    public int getLinesOfCodeChange() {
        return this.getLinesDelta();
    }

    public int getLineValue() {
        return this.getNewLines();
    }

    public int getRemovingValue() {
        if (this.getLinesDelta() > 0) {
            return this.getReplacedLines();
        }
        return -this.getLinesDelta() + this.getReplacedLines();
    }

    public int getFileCountChange() {
        return this.getFileCountDelta();
    }

    public String getRevision() {
        return this.getRevisionNumber();
    }
}

