/*
 * Decompiled with CFR 0.152.
 */
package net.sf.statcvs.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.statcvs.model.Author;
import net.sf.statcvs.model.CvsBranch;
import net.sf.statcvs.model.CvsRevision;
import net.sf.statcvs.model.Directory;

public class CvsFile
implements Comparable {
    private final String filename;
    private final SortedSet revisions = new TreeSet();
    private final Directory directory;
    private final Map cvsBranches;
    private final Set authors = new HashSet();

    public CvsFile(String name, Directory directory, Map cvsBranches) {
        this.filename = name;
        this.directory = directory;
        this.cvsBranches = cvsBranches;
        if (directory != null) {
            directory.addFile(this);
        }
    }

    public String getFilenameWithPath() {
        return this.filename;
    }

    public String getFilename() {
        int lastDelim = this.filename.lastIndexOf("/");
        return this.filename.substring(lastDelim + 1, this.filename.length());
    }

    public Directory getDirectory() {
        return this.directory;
    }

    public CvsRevision getLatestRevision() {
        return this.getLatestRevision(CvsBranch.HEAD_BRANCH_NAME);
    }

    public CvsRevision getLatestRevision(String branchName) {
        CvsBranch cvsBranch = (CvsBranch)this.cvsBranches.get(branchName);
        if (cvsBranch == null) {
            throw new IllegalArgumentException("Cannot find branch with name '" + branchName + "'.");
        }
        return cvsBranch.getLastCvsRevision();
    }

    public CvsRevision getInitialRevision() {
        return (CvsRevision)this.revisions.first();
    }

    public CvsRevision getInitialRevision(String branchName) {
        CvsBranch cvsBranch = (CvsBranch)this.cvsBranches.get(branchName);
        if (cvsBranch == null) {
            throw new IllegalArgumentException("Cannot find branch with name '" + branchName + "'.");
        }
        return cvsBranch.getFirstCvsRevision();
    }

    public SortedSet getRevisions() {
        return this.revisions;
    }

    public int getCurrentLinesOfCode() {
        return this.getCurrentLinesOfCode(CvsBranch.HEAD_BRANCH_NAME);
    }

    public int getCurrentLinesOfCode(String branchName) {
        return this.getLatestRevision(branchName).getLines();
    }

    public boolean isDead() {
        return this.isDead(CvsBranch.HEAD_BRANCH_NAME);
    }

    public boolean isDead(String branchName) {
        return this.getLatestRevision(branchName).isDead();
    }

    public boolean hasAuthor(Author author) {
        return this.authors.contains(author);
    }

    public CvsRevision getPreviousRevision(CvsRevision revision) {
        return revision.getPreviousRevision();
    }

    public String toString() {
        return this.getFilenameWithPath() + " (" + this.revisions.size() + " revisions)";
    }

    public int compareTo(Object other) {
        return this.filename.compareTo(((CvsFile)other).filename);
    }

    public CvsRevision addInitialRevision(CvsBranch mainBranch, String revisionNumber, Author author, Date date, String comment, int lines) {
        CvsRevision result = new CvsRevision(this, mainBranch, revisionNumber, 1, author, date, comment, lines, lines, 0);
        this.addRevision(result);
        return result;
    }

    public CvsRevision addChangeRevision(CvsBranch mainBranch, String revisionNumber, Author author, Date date, String comment, int lines, int linesDelta, int replacedLines) {
        CvsRevision result = new CvsRevision(this, mainBranch, revisionNumber, 2, author, date, comment, lines, linesDelta, replacedLines);
        this.addRevision(result);
        return result;
    }

    public CvsRevision addDeletionRevision(CvsBranch mainBranch, String revisionNumber, Author author, Date date, String comment, int lines) {
        CvsRevision result = new CvsRevision(this, mainBranch, revisionNumber, 3, author, date, comment, 0, -lines, 0);
        this.addRevision(result);
        return result;
    }

    public CvsRevision addBeginOfLogRevision(Date date, int lines) {
        CvsRevision result = new CvsRevision(this, null, "0.0", 5, null, date, null, lines, 0, 0);
        this.addRevision(result);
        return result;
    }

    private void addRevision(CvsRevision revision) {
        this.revisions.add(revision);
        if (revision.getAuthor() != null) {
            this.authors.add(revision.getAuthor());
        }
    }
}

