/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.xpath;

import electric.util.lex.Lex;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.Node;
import electric.xml.NodeList;
import electric.xml.Nodes;
import electric.xml.Parent;
import electric.xml.Selection;
import electric.xml.XPathException;
import electric.xml.xpath.NameNode;
import electric.xml.xpath.TMEXPath;
import java.io.IOException;

public class AttributePredicate
extends NameNode {
    private String key;
    private String value;
    private boolean not;

    public AttributePredicate(String string) throws XPathException {
        try {
            int index;
            int equals;
            int openBracket = string.indexOf(91);
            if (openBracket > 0) {
                this.setName(string.substring(0, openBracket));
            }
            if ((equals = string.indexOf(61, index = openBracket + 2)) == -1) {
                int closeBracket = string.indexOf(93, index);
                if (closeBracket == -1) {
                    throw new XPathException("missing ] in " + string);
                }
                this.key = string.substring(index, closeBracket).trim();
            } else {
                if (string.charAt(equals - 1) == '!') {
                    this.not = true;
                    this.key = string.substring(index, equals - 1).trim();
                } else {
                    this.key = string.substring(index, equals).trim();
                }
                Lex lex = new Lex(string.substring(equals + 1));
                lex.skipWhitespace();
                int ch = lex.read();
                if (ch == 34) {
                    this.value = lex.readToPattern("\"", 66);
                } else if (ch == 39) {
                    this.value = lex.readToPattern("'", 66);
                } else {
                    throw new XPathException("missing quote at start of attribute value");
                }
                lex.readChar(93);
            }
        }
        catch (IOException exception) {
            throw new XPathException(exception.toString());
        }
    }

    public void addNodes(TMEXPath xpath, Node node, NodeList list) throws XPathException {
        NodeList selected = new NodeList();
        Elements elements = ((Parent)node).getElements();
        while (elements.hasMoreElements()) {
            Element element = elements.next();
            String attributeValue = element.getAttributeValue(this.key);
            if (this.value != null ? (!this.not ? !this.value.equals(attributeValue) : this.value.equals(attributeValue)) : attributeValue == null) continue;
            if (this.name == null) {
                selected.append(new Selection(element));
                continue;
            }
            if (!element.hasName(this.getNamespace(xpath, node), this.name)) continue;
            selected.append(new Selection(element));
        }
        this.addNextNodes(xpath, new Nodes(selected), list);
    }
}

