/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.model;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.java.JavaSource;
import electric.xml.Element;
import electric.xml.Elements;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.complex.any.AnyHandler;
import electric.xml.io.model.All;
import electric.xml.io.model.Choice;
import electric.xml.io.model.Group;
import electric.xml.io.model.IModel;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaAttribute;
import electric.xml.io.schema.SchemaElement;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.util.Vector;

public class Sequence
extends All {
    private IModel[] models = new IModel[0];
    private AnyHandler anyHandler;

    public Sequence(Type parentType) {
        this.setParentType(parentType);
    }

    public Sequence(Type parentType, Element schema) throws SchemaException {
        this.setParentType(parentType);
        this.readSchema(schema);
    }

    public Sequence(Schema schemaObject, Element schemaElement) throws SchemaException {
        this.setSchema(schemaObject);
        this.readSchema(schemaElement);
    }

    public void addDependencies(Vector dependencies) throws SchemaException {
        super.addDependencies(dependencies);
        int i = 0;
        while (i < this.models.length) {
            this.models[i].addDependencies(dependencies);
            ++i;
        }
    }

    public void writeJava(JavaSource source) throws SchemaException {
        super.writeJava(source);
        int i = 0;
        while (i < this.models.length) {
            this.models[i].writeJava(source);
            ++i;
        }
        if (this.anyHandler != null) {
            this.anyHandler.writeJava(source);
        }
    }

    public void readSchema(Element schema) throws SchemaException {
        Elements elements = schema.getElements();
        while (elements.hasMoreElements()) {
            Element child = elements.next();
            if (this.parentType != null) {
                if (child.getName().equals("all")) {
                    this.addModel(new All(this.parentType, child));
                    continue;
                }
                if (child.getName().equals("annotation")) continue;
                if (child.getName().equals("any")) {
                    this.anyHandler = new AnyHandler(child, this.parentType);
                    continue;
                }
                if (child.getName().equals("anyAttribute")) continue;
                if (child.getName().equals("choice")) {
                    this.addModel(new Choice(this.parentType, child));
                    continue;
                }
                if (child.getName().equals("element")) {
                    this.addElement(new SchemaElement(this.parentType, child));
                    continue;
                }
                if (child.getName().equals("group")) {
                    this.addModel(new Group(this.parentType, child));
                    continue;
                }
                if (child.getName().equals("sequence")) {
                    this.addModel(new Sequence(this.parentType, child));
                    continue;
                }
                throw new SchemaException("<sequence> in type " + this.parentType.getQName() + " must currently be followed by <element>, <all>, <choice>, <group>, <sequence>,  or <annotation>");
            }
            if (child.getName().equals("all")) {
                this.addModel(new All(this.schema, child));
                continue;
            }
            if (child.getName().equals("annotation") || child.getName().equals("any") || child.getName().equals("anyAttribute")) continue;
            if (child.getName().equals("choice")) {
                this.addModel(new Choice(this.schema, child));
                continue;
            }
            if (child.getName().equals("element")) {
                this.addElement(new SchemaElement(this.schema, child));
                continue;
            }
            if (child.getName().equals("group")) {
                this.addModel(new Group(this.schema, child));
                continue;
            }
            if (child.getName().equals("sequence")) {
                this.addModel(new Sequence(this.schema, child));
                continue;
            }
            throw new SchemaException("<sequence> must currently be followed by <element>, <all>, <choice>, <group>, <sequence>,  or <annotation>");
        }
    }

    public void writeSchema(Element element, boolean annotated) throws SchemaException {
        String xsdPrefix = Type.getXSDPrefix(element);
        Element sequence = element.addElement(xsdPrefix, "sequence");
        if (this.elements.length > 0) {
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].writeSchema(sequence, annotated);
                ++i;
            }
        }
        int i = 0;
        while (i < this.models.length) {
            this.models[i].writeSchema(sequence, annotated);
            ++i;
        }
        if (this.anyHandler != null) {
            this.anyHandler.writeSchema(sequence, annotated);
        }
    }

    public void setSchema(Schema schema) {
        super.setSchema(schema);
        int i = 0;
        while (i < this.models.length) {
            this.models[i].setSchema(schema);
            ++i;
        }
    }

    public void addModel(IModel model) {
        this.models = (IModel[])ArrayUtil.addElement(this.models, model);
    }

    public SchemaElement getSchemaElement(String name) throws SchemaException {
        int i = 0;
        while (i < this.elements.length) {
            if (this.elements[i].getName().equals(name)) {
                return this.elements[i];
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.models.length) {
            SchemaElement retval = this.models[i2].getSchemaElement(name);
            if (retval != null) {
                return retval;
            }
            ++i2;
        }
        return null;
    }

    public SchemaAttribute getSchemaAttribute(String name) throws SchemaException {
        int i = 0;
        while (i < this.models.length) {
            SchemaAttribute retval = this.models[i].getSchemaAttribute(name);
            if (retval != null) {
                return retval;
            }
            ++i;
        }
        return null;
    }

    public void forceResolution() {
        super.forceResolution();
        int i = 0;
        while (i < this.models.length) {
            this.models[i].forceResolution();
            ++i;
        }
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        super.writeObject(writer, object);
        int i = 0;
        while (i < this.models.length) {
            this.models[i].writeObject(writer, object);
            ++i;
        }
        if (this.anyHandler != null) {
            this.anyHandler.writeObject(writer, object);
        }
    }

    public void readObject(IReader reader, Value value) throws IOException {
        super.readObject(reader, value);
        int i = 0;
        while (i < this.models.length) {
            this.models[i].readObject(reader, value);
            ++i;
        }
        if (this.anyHandler != null) {
            this.anyHandler.readObject(reader, value);
        }
    }
}

