/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.mapping;

import electric.util.file.FileUtil;
import electric.util.log.Log;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.ParseException;
import electric.xml.io.mapping.DirectoryLoader;
import electric.xml.io.mapping.FileLoader;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.mapping.JARLoader;
import electric.xml.io.mapping.MapFile;
import java.io.IOException;

public final class MapFileLoader
implements ILoaderConstants,
IEXMLLoggingConstants {
    private DirectoryLoader directoryLoader = new DirectoryLoader();
    private JARLoader jarLoader = new JARLoader();
    private FileLoader fileLoader = new FileLoader();

    public MapFile[] loadMapFiles(String path) throws IOException, ParseException, SecurityException {
        if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
            Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("read mappings from path " + path));
        }
        MapFile[] mapFiles = null;
        if (path.toLowerCase().endsWith(".jar") || path.toLowerCase().endsWith(".zip")) {
            mapFiles = this.jarLoader.loadMapFiles(path);
        } else if (FileUtil.isDirectory(path)) {
            mapFiles = this.directoryLoader.loadMapFiles(path);
        } else if (path.toLowerCase().endsWith(".map")) {
            mapFiles = this.fileLoader.loadMapFiles(path);
        }
        if (mapFiles == null) {
            if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
                Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("no mappings could be loaded from path " + path));
            }
            return null;
        }
        return mapFiles;
    }
}

