/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.mapping;

import electric.util.array.ArrayUtil;
import electric.util.classloader.ClassLoaders;
import electric.util.io.Streams;
import electric.util.log.Log;
import electric.xml.Document;
import electric.xml.IEXMLLoggingConstants;
import electric.xml.ParseException;
import electric.xml.io.mapping.ILoader;
import electric.xml.io.mapping.ILoaderConstants;
import electric.xml.io.mapping.MapFile;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class JARLoader
implements ILoader,
ILoaderConstants,
IEXMLLoggingConstants {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapFile[] loadMapFiles(String path) throws IOException, ParseException {
        MapFile[] mapFileArray;
        InputStream input = null;
        try {
            input = ClassLoaders.getInputStream("file:/" + path);
        }
        catch (IOException exception) {
            if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
                Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("no mappings loaded from: " + path));
            }
            return ILoaderConstants.NO_MAP_FILES;
        }
        try {
            mapFileArray = this.loadMapFiles(path, input);
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            input.close();
            throw throwable;
        }
        input.close();
        return mapFileArray;
    }

    private MapFile[] loadMapFiles(String path, InputStream input) {
        MapFile[] mapFiles;
        block6: {
            mapFiles = new MapFile[]{};
            ZipInputStream jarInput = null;
            ZipEntry entry = null;
            try {
                int count = 0;
                jarInput = new ZipInputStream(input);
                while ((entry = jarInput.getNextEntry()) != null) {
                    if (!entry.getName().toLowerCase().endsWith(".map")) continue;
                    ++count;
                    MapFile mapFile = this.loadMapFile(jarInput, entry);
                    mapFiles = (MapFile[])ArrayUtil.addElement(mapFiles, mapFile);
                }
                if (count == 0 && Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
                    Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("no mappings loaded from: " + path));
                }
            }
            catch (IOException exception) {
                if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
                    Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("IOException reading " + entry.getName() + ". " + "these mappings will be omitted."));
                }
            }
            catch (ParseException exception) {
                if (!Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) break block6;
                Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("the map file " + entry.getName() + " does not parse correctly. mapping omitted."));
            }
        }
        return mapFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MapFile loadMapFile(ZipInputStream jarInput, ZipEntry entry) throws IOException, ParseException {
        MapFile mapFile;
        if (Log.isLogging(IEXMLLoggingConstants.MAPPING_EVENT)) {
            Log.log(IEXMLLoggingConstants.MAPPING_EVENT, (Object)("load map file " + entry.getName()));
        }
        try {
            mapFile = new MapFile(entry.getName(), new Document(Streams.readFully(jarInput)));
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            jarInput.closeEntry();
            throw throwable;
        }
        jarInput.closeEntry();
        return mapFile;
    }
}

