/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.complex.any;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.util.java.JavaNames;
import electric.util.java.JavaSource;
import electric.util.license.Enabler;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xml.Attribute;
import electric.xml.Attributes;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.accessors.Accessor;
import electric.xml.io.accessors.IAccessible;
import electric.xml.io.accessors.UnboundAccessor;
import electric.xml.io.schema.ISchemaConstants;
import electric.xml.io.schema.SchemaException;
import electric.xml.io.schema.SchemaProperties;
import java.io.IOException;
import java.lang.reflect.Array;

public class AnyAttributeHandler
implements ISchemaConstants,
IAccessible {
    private static final Class ATTRIBUTE_CLASS = class$electric$xml$Attribute == null ? (class$electric$xml$Attribute = AnyAttributeHandler.class$("electric.xml.Attribute")) : class$electric$xml$Attribute;
    private static final Class ATTRIBUTE_ARRAY_CLASS = Array.newInstance(class$electric$xml$Attribute == null ? (class$electric$xml$Attribute = AnyAttributeHandler.class$("electric.xml.Attribute")) : class$electric$xml$Attribute, 0).getClass();
    private static String defaultType = "electric.xml.Attribute";
    private static boolean enabled;
    private static boolean allowEnable;
    Type parentType;
    String processContents;
    String namespace;
    int minOccurs = 0;
    int maxOccurs = 1;
    Accessor accessor;
    static /* synthetic */ Class class$electric$xml$Attribute;

    public AnyAttributeHandler(Element anyAttribute, Type parentType) throws SchemaException {
        String max;
        this.checkEnabled();
        this.parentType = parentType;
        this.accessor = new UnboundAccessor(this, "anyAttributeReference", anyAttribute);
        String min = anyAttribute.getAttributeValue("minOccurs");
        if (min != null) {
            this.minOccurs = Integer.parseInt(min);
        }
        if ((max = anyAttribute.getAttributeValue("maxOccurs")) != null) {
            this.maxOccurs = max.equals("unbounded") || max.equals("*") ? Integer.MAX_VALUE : Integer.parseInt(max);
        }
        this.processContents = anyAttribute.getAttribute("processContents");
        this.namespace = anyAttribute.getAttribute("namespace");
    }

    public void readObject(IReader reader, Value value) throws IOException {
        this.checkEnabled();
        if (this.accessor.getJavaName().equals(JavaNames.getJavaName(ATTRIBUTE_CLASS))) {
            this.readAttribute(reader, value);
        }
        if (this.accessor.getJavaName().equals(JavaNames.getJavaName(ATTRIBUTE_ARRAY_CLASS))) {
            this.readAttribute(reader, value);
        }
    }

    private void readAttribute(IReader reader, Value value) throws IOException {
        Value newValue = new Value();
        if (value.getObject() != null) {
            return;
        }
        Attributes attributes = reader.getElement().getAttributeObjects();
        if (this.maxOccurs > 1) {
            Attribute[] attributeArray = new Attribute[]{};
            while (attributes.hasMoreElements()) {
                Attribute attribute = attributes.next();
                attributeArray = (Attribute[])ArrayUtil.addElement(attributeArray, new Attribute(attribute));
            }
        } else {
            newValue.setObject(new Attribute(attributes.next()));
        }
        try {
            this.accessor.set(value, newValue);
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }

    public void writeObject(IWriter writer, Object object) throws IOException {
        this.checkEnabled();
        if (this.accessor.getJavaName().equals((class$electric$xml$Attribute == null ? (class$electric$xml$Attribute = AnyAttributeHandler.class$("electric.xml.Attribute")) : class$electric$xml$Attribute).getName())) {
            this.writeAttribute(writer, object);
        }
        if (this.accessor.getJavaName().equals((class$electric$xml$Attribute == null ? (class$electric$xml$Attribute = AnyAttributeHandler.class$("electric.xml.Attribute")) : class$electric$xml$Attribute).getName() + "[]")) {
            this.writeAttribute(writer, object);
        }
    }

    public void writeAttribute(IWriter writer, Object object) throws IOException {
        try {
            Object source = this.accessor.get(object);
            if (source instanceof Attribute) {
                Attribute attribute = (Attribute)source;
                String prefix = writer.getElement().getPrefix(attribute.getNamespace(), attribute.getPrefix());
                writer.writeAttribute(prefix, attribute.getName(), attribute.getValue());
            }
            if (source instanceof Attribute[]) {
                Attribute[] array = (Attribute[])source;
                int i = 0;
                while (i < array.length) {
                    Attribute attribute = array[i];
                    String prefix = writer.getElement().getPrefix(attribute.getNamespace(), attribute.getPrefix());
                    writer.writeAttribute(prefix, attribute.getName(), attribute.getValue());
                    ++i;
                }
            }
        }
        catch (IOException exception) {
            throw exception;
        }
        catch (Exception exception) {
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            throw new IOException(exception.toString());
        }
    }

    public void writeJava(JavaSource source) throws SchemaException {
        this.checkEnabled();
        this.accessor.writeJava(source);
    }

    public void writeSchema(Element schema, boolean annotated) throws SchemaException {
        this.checkEnabled();
        String xsdPrefix = schema.getPrefix(SchemaProperties.getDefaultSchema(), "xsd");
        Element any = schema.addElement(xsdPrefix, "anyAttribute");
        any.setAttribute("minOccurs", "" + this.minOccurs);
        if (this.minOccurs != 1) {
            any.setAttribute("minOccurs", Integer.toString(this.minOccurs));
        }
        if (this.maxOccurs == Integer.MAX_VALUE) {
            any.setAttribute("maxOccurs", "unbounded");
        } else if (this.maxOccurs != 1) {
            any.setAttribute("maxOccurs", Integer.toString(this.maxOccurs));
        }
        if (annotated && this.accessor != null) {
            this.accessor.annotateSchema(any);
        }
        if (this.namespace != null) {
            any.setAttribute("namespace", this.namespace);
        }
        if (this.processContents != null) {
            any.setAttribute("processContents", this.processContents);
        }
    }

    public Class getAccessibleJavaClass() throws SchemaException {
        return this.parentType.getJavaClass();
    }

    public String getAccessibleJavaName() throws SchemaException {
        if (this.maxOccurs == 1) {
            return defaultType;
        }
        return defaultType + "[]";
    }

    public static void enable() {
        if (enabled) {
            return;
        }
        if (!allowEnable) {
            throw new IllegalStateException("support for <anyAttribute> wildcards cannot be enabled once it is disabled");
        }
        enabled = Enabler.enable();
        if (!enabled && Log.isLogging(ILoggingConstants.WARNING_EVENT)) {
            Log.log(ILoggingConstants.WARNING_EVENT, (Object)"support for <anyAttribute> wildcards could not be enabled");
        }
    }

    public static boolean isEnabled() {
        return enabled;
    }

    private void checkEnabled() {
        if (!enabled) {
            throw new IllegalStateException("support for <anyAttribute> wildcards is disabled");
        }
    }

    public static void disable() {
        enabled = false;
        allowEnable = false;
        Log.log(ILoggingConstants.WARNING_EVENT, (Object)"support for <anyAttribute> wildcards is disabled");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        allowEnable = true;
    }
}

