/*
 * Decompiled with CFR 0.152.
 */
package electric.xml.io.array;

import electric.util.Value;
import electric.util.array.ArrayUtil;
import electric.xml.io.IReader;
import electric.xml.io.IWriter;
import electric.xml.io.Type;
import electric.xml.io.array.ArrayType;
import electric.xml.io.array.MultidimEncodedArrayType;
import electric.xml.io.schema.Schema;
import electric.xml.io.schema.SchemaException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.StringTokenizer;

public class SOAP12MultidimEncodedArrayType
extends MultidimEncodedArrayType {
    public SOAP12MultidimEncodedArrayType(Schema schema, String name, String componentQName, int[] dimensions) {
        super(schema, name, componentQName, dimensions);
    }

    public void writeType(IWriter writer) throws IOException {
    }

    public void writeObject(IWriter writer, Object object) throws SchemaException, IOException {
        int[] new_dimensions = (int[])this.dimensions.clone();
        String soapPrefix = writer.getElement().getPrefix("http://www.w3.org/2003/05/soap-encoding", "soapenc");
        String arrayTypeQName = this.getArrayTypeQName(object, writer.getElement(), new_dimensions, true);
        String arraySizeAttribute = "";
        int i = 0;
        while (i < new_dimensions.length) {
            arraySizeAttribute = arraySizeAttribute + "" + new_dimensions[i];
            if (i + 1 < new_dimensions.length) {
                arraySizeAttribute = arraySizeAttribute + " ";
            }
            ++i;
        }
        writer.writeAttribute(soapPrefix, "arraySize", arraySizeAttribute);
        Type runtimeComponentType = this.getComponentType();
        String itemType = null;
        itemType = runtimeComponentType instanceof ArrayType ? ((ArrayType)runtimeComponentType).getArrayTypeQName(writer.getElement()) : runtimeComponentType.getName(writer.getElement());
        writer.writeAttribute(soapPrefix, "itemType", itemType);
        this.writeMultiDimArray(object, writer, new_dimensions);
    }

    public void readObject(IReader reader, Value value) throws SchemaException, IOException {
        IReader[] children = reader.getReaders();
        Object array = null;
        String arraySize = reader.getElement().getAttributeValue("arraySize");
        int[] wireDimensions = null;
        if (arraySize == null || arraySize.length() == 0) {
            wireDimensions = this.dimensions;
        } else {
            StringTokenizer wsTokenizer = new StringTokenizer(arraySize, " ");
            int numDimensions = wsTokenizer.countTokens();
            wireDimensions = new int[numDimensions];
            int i = 0;
            while (wsTokenizer.hasMoreTokens()) {
                wireDimensions[i++] = Integer.parseInt(wsTokenizer.nextToken());
            }
        }
        if (ArrayUtil.indexOf(-1, wireDimensions) != -1) {
            int i = 0;
            while (i < wireDimensions.length) {
                if (wireDimensions[i] == -1) {
                    wireDimensions[i] = 0;
                }
                ++i;
            }
        }
        array = Array.newInstance(this.getComponentType().getJavaClass(), wireDimensions);
        int i = 0;
        while (i < children.length) {
            int j = i;
            Object object = array;
            int[] position = new int[this.dimensions.length];
            int z = position.length - 1;
            while (z >= 0) {
                position[z] = j % wireDimensions[z];
                j /= wireDimensions[z];
                --z;
            }
            int z2 = 0;
            while (z2 < this.dimensions.length - 1) {
                object = Array.get(object, position[z2]);
                ++z2;
            }
            Object item = children[i].readValue(this.getComponentType()).getObject();
            Array.set(object, position[position.length - 1], item);
            ++i;
        }
        value.setObject(array);
    }
}

