/*
 * Decompiled with CFR 0.152.
 */
package electric.util.reflect;

import electric.soap.ISOAPConstants;
import electric.util.array.ArrayUtil;
import electric.util.async.Async;
import electric.util.reflect.IOperation;
import electric.util.reflect.MethodAmbiguityException;
import electric.util.reflect.Reflect;
import electric.xml.io.schema.ISchemaConstants;

public final class OperationLookup
implements ISOAPConstants,
ISchemaConstants {
    public static IOperation getOperation(IOperation[] operations, String methodName, Class[] argClasses) throws NoSuchMethodException {
        boolean isAsync = Async.isAsyncSignature(argClasses);
        if (isAsync) {
            argClasses = (Class[])ArrayUtil.removeElementAt(argClasses, argClasses.length - 1);
        }
        try {
            IOperation[] ops = OperationLookup.getOperations(operations, methodName, argClasses, isAsync, true, false);
            return ops[0];
        }
        catch (MethodAmbiguityException exception) {
            throw exception;
        }
        catch (NoSuchMethodException exception) {
            return OperationLookup.getOperation(operations, methodName, argClasses, isAsync, false, false);
        }
    }

    public static IOperation getOperation(IOperation[] operations, String methodName, Class[] inArgClasses, boolean isAsync) throws NoSuchMethodException {
        try {
            return OperationLookup.getOperation(operations, methodName, inArgClasses, isAsync, true, true);
        }
        catch (MethodAmbiguityException exception) {
            throw exception;
        }
        catch (NoSuchMethodException exception) {
            return OperationLookup.getOperation(operations, methodName, inArgClasses, isAsync, false, true);
        }
    }

    private static IOperation getOperation(IOperation[] operations, String methodName, Class[] argClasses, boolean isAsync, boolean exact, boolean in) throws NoSuchMethodException {
        IOperation[] returns = null;
        try {
            returns = OperationLookup.getOperations(operations, isAsync, in, argClasses, exact, methodName);
            if (returns.length == 1) {
                return returns[0];
            }
            IOperation dominant = OperationLookup.getDominantOperation(returns, in);
            if (dominant == null) {
                throw OperationLookup.newMethodAmbiguityException(methodName, argClasses);
            }
            return dominant;
        }
        catch (ClassNotFoundException exception) {
            throw OperationLookup.newNoSuchMethodException(methodName, argClasses, exception);
        }
    }

    private static IOperation[] getOperations(IOperation[] operations, String methodName, Class[] argClasses, boolean isAsync, boolean exact, boolean in) throws NoSuchMethodException {
        IOperation[] returns = null;
        try {
            returns = OperationLookup.getOperations(operations, isAsync, in, argClasses, exact, methodName);
            if (returns.length == 1) {
                return returns;
            }
            IOperation dominant = OperationLookup.getDominantOperation(returns, in);
            if (dominant != null) {
                return new IOperation[]{dominant};
            }
            return returns;
        }
        catch (ClassNotFoundException exception) {
            throw OperationLookup.newNoSuchMethodException(methodName, argClasses, exception);
        }
    }

    private static IOperation getDominantOperation(IOperation[] operations, boolean in) throws ClassNotFoundException {
        int i = 0;
        while (i < operations.length) {
            boolean dominant = true;
            Class[] classes = OperationLookup.getArgClasses(operations[i], in);
            int j = 0;
            while (j < operations.length) {
                if (i != j && !Reflect.dominates(classes, OperationLookup.getArgClasses(operations[j], in))) {
                    dominant = false;
                    break;
                }
                ++j;
            }
            if (dominant) {
                return operations[i];
            }
            ++i;
        }
        return null;
    }

    private static IOperation[] getOperations(IOperation[] operations, boolean isAsync, boolean in, Class[] argClasses, boolean exact, String methodName) throws ClassNotFoundException, NoSuchMethodException {
        IOperation[] returns = new IOperation[]{};
        int i = 0;
        while (i < operations.length) {
            if (operations[i].isAsync() == isAsync && Reflect.matches(OperationLookup.getArgClasses(operations[i], in), argClasses, exact)) {
                returns = (IOperation[])ArrayUtil.addElement(returns, operations[i]);
            }
            ++i;
        }
        if (returns.length == 0) {
            throw OperationLookup.newNoSuchMethodException(methodName, argClasses);
        }
        return returns;
    }

    private static Class[] getArgClasses(IOperation operation, boolean in) throws ClassNotFoundException {
        return in ? operation.getInArgClasses() : operation.getArgClasses();
    }

    public static IOperation getOperation(IOperation[] operations, String methodName, int argCount) throws NoSuchMethodException {
        int match = -1;
        int matchCount = 0;
        int i = 0;
        while (i < operations.length) {
            if (operations[i].getInArgCount() == argCount) {
                match = i;
                ++matchCount;
            }
            ++i;
        }
        if (matchCount == 1) {
            return operations[match];
        }
        if (matchCount == 0) {
            throw OperationLookup.newNoSuchMethodException(methodName, argCount);
        }
        throw OperationLookup.newMethodAmbiguityException(methodName, argCount);
    }

    public static IOperation[] getOperationsWithExactArguments(IOperation[] operations, int inArgCount, boolean isAsync) {
        IOperation[] returns = new IOperation[]{};
        int i = 0;
        while (i < operations.length) {
            if (operations[i].isAsync() == isAsync && operations[i].getInArgCount() == inArgCount) {
                returns = (IOperation[])ArrayUtil.addElement(returns, operations[i]);
            }
            ++i;
        }
        return returns;
    }

    public static IOperation[] getOperationsWithMoreArguments(IOperation[] operations, int inArgCount, boolean isAsync) {
        IOperation[] returns = new IOperation[]{};
        int i = 0;
        while (i < operations.length) {
            if (operations[i].isAsync() == isAsync && operations[i].getInArgCount() >= inArgCount) {
                returns = (IOperation[])ArrayUtil.addElement(returns, operations[i]);
            }
            ++i;
        }
        return returns;
    }

    private static NoSuchMethodException newNoSuchMethodException(String methodName, int argCount) {
        return new NoSuchMethodException("could not find operation corresponding to " + OperationLookup.getSignature(methodName, argCount) + ". log MAPPING events to check that client-side map files are being read.");
    }

    private static NoSuchMethodException newNoSuchMethodException(String methodName, Class[] argClasses) {
        return new NoSuchMethodException("could not find operation corresponding to " + OperationLookup.getSignature(methodName, argClasses) + ". log MAPPING events to check that client-side map files are being read.");
    }

    private static NoSuchMethodException newNoSuchMethodException(String methodName, Class[] argClasses, Exception exception) {
        return new NoSuchMethodException("could not find operation corresponding to " + OperationLookup.getSignature(methodName, argClasses) + ": " + exception);
    }

    private static MethodAmbiguityException newMethodAmbiguityException(String methodName, Class[] argClasses) {
        return new MethodAmbiguityException("found more than one operation corresponding to " + OperationLookup.getSignature(methodName, argClasses));
    }

    private static MethodAmbiguityException newMethodAmbiguityException(String methodName, int argCount) {
        return new MethodAmbiguityException("found more than one operation corresponding to " + OperationLookup.getSignature(methodName, argCount));
    }

    public static String getSignature(String methodName, Class[] argClasses) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(methodName).append('(');
        int i = 0;
        while (i < argClasses.length) {
            if (i > 0) {
                buffer.append(',');
            }
            if (argClasses[i] == null) {
                buffer.append("null");
            } else {
                buffer.append(argClasses[i].getName());
            }
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    public static String getSignature(String methodName, int argCount) {
        return methodName + "(" + argCount + " args)";
    }
}

