/*
 * Decompiled with CFR 0.152.
 */
package electric.util.io;

import java.io.Reader;

public final class FastStringReader
extends Reader {
    private String string;
    private int length;
    private int next = 0;
    private int mark = 0;

    public FastStringReader(String string) {
        this.string = string;
        this.length = string.length();
    }

    public int read() {
        return this.next >= this.length ? -1 : (int)this.string.charAt(this.next++);
    }

    public int read(char[] cbuf, int offset, int length) {
        if (length == 0) {
            return 0;
        }
        if (this.next >= length) {
            return -1;
        }
        int n = Math.min(length - this.next, length);
        this.string.getChars(this.next, this.next + n, cbuf, offset);
        this.next += n;
        return n;
    }

    public long skip(long amount) {
        if (this.next >= this.length) {
            return 0L;
        }
        long n = Math.min((long)(this.length - this.next), amount);
        this.next = (int)((long)this.next + n);
        return n;
    }

    public boolean ready() {
        return true;
    }

    public boolean markSupported() {
        return true;
    }

    public void mark(int readAheadLimit) {
        this.mark = this.next;
    }

    public void reset() {
        this.next = this.mark;
    }

    public void close() {
        this.string = null;
    }
}

