/*
 * Decompiled with CFR 0.152.
 */
package electric.util.http;

import electric.util.http.AuthHeaderData;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class DigestUtil {
    private static char[] hexCharMap = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String digestHexFormat(byte[] byteArray) {
        StringBuffer retVal = new StringBuffer(byteArray.length);
        int i = 0;
        while (i < byteArray.length) {
            int high = byteArray[i] >> 4 & 0xF;
            retVal.append(hexCharMap[high]);
            int low = byteArray[i] & 0xF;
            retVal.append(hexCharMap[low]);
            ++i;
        }
        return retVal.toString();
    }

    public static String calculateDigest(AuthHeaderData authData, String password) throws NoSuchAlgorithmException {
        String A1 = authData.userName + ":" + authData.realmName + ":" + password;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] HA1 = md5.digest(A1.getBytes());
        String HA1Str = DigestUtil.digestHexFormat(HA1);
        String A2 = authData.httpMethod + ":" + authData.uri;
        md5.reset();
        byte[] HA2 = md5.digest(A2.getBytes());
        String HA2Str = DigestUtil.digestHexFormat(HA2);
        String response = null;
        response = authData.qop == null || authData.qop.length() == 0 || !"auth".equals(authData.qop) ? HA1Str + ":" + authData.nonce + ":" + HA2Str : HA1Str + ":" + authData.nonce + ":" + authData.nc + ":" + authData.cnonce + ":" + authData.qop + ":" + HA2Str;
        md5.reset();
        byte[] responseHash = md5.digest(response.getBytes());
        return DigestUtil.digestHexFormat(responseHash);
    }
}

