/*
 * Decompiled with CFR 0.152.
 */
package electric.util.context;

import electric.util.Context;
import electric.xml.Element;
import electric.xml.Elements;

public final class ContextUtil {
    public static void populate(Context context, Element element) {
        Elements elements = element.getElements();
        while (elements.hasMoreElements()) {
            Object value;
            Element property = elements.next();
            Object object = value = property.hasElements() ? property : property.getString();
            if (value == null) continue;
            context.addProperty(property.getName(), value);
        }
    }

    private static boolean canAccessSysProps() {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan == null) {
            return true;
        }
        try {
            secMan.checkPropertiesAccess();
            return true;
        }
        catch (SecurityException exception) {
            return false;
        }
    }

    public static void copySystemProperties(String[][] systemProps, Context context) {
        if (!ContextUtil.canAccessSysProps()) {
            return;
        }
        int i = 0;
        while (i < systemProps.length) {
            String property = System.getProperty(systemProps[i][0]);
            if (property != null) {
                context.setProperty(systemProps[i][1], property);
            }
            ++i;
        }
    }

    public static void copyToContext(Context context, Element config, String propertyName) {
        ContextUtil.copyToContext(context, config, propertyName, propertyName);
    }

    public static void copyToContext(Context context, Element config, String propertyName, String configName) {
        Elements elements = config.getElements(configName);
        while (elements.hasMoreElements()) {
            Object propValue;
            Element property = elements.next();
            Object obj = context.getProperty("-" + propertyName);
            Object object = propValue = property.getElements().size() > 0 ? property : property.getString();
            if (obj != null && propValue != null && obj.equals(propValue) || propValue == null) continue;
            context.addProperty(propertyName, propValue);
        }
    }
}

