/*
 * Decompiled with CFR 0.152.
 */
package electric.uddi.server;

import electric.proxy.IReference;
import electric.service.IService;
import electric.soap.ISOAPConstants;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPException;
import electric.soap.SOAPMessage;
import electric.soap.util.SOAPHeaders;
import electric.uddi.Authorization;
import electric.uddi.ICommand;
import electric.uddi.IUDDIConstants;
import electric.uddi.IUDDIServer;
import electric.uddi.IUDDIServerHolder;
import electric.uddi.Messages;
import electric.uddi.UDDIException;
import electric.util.Context;
import electric.wsdl.WSDL;
import electric.xml.Document;
import electric.xml.Element;
import electric.xml.io.IReader;
import electric.xml.io.ISerializable;
import electric.xml.io.IWriter;
import electric.xml.io.literal.LiteralReader;
import electric.xml.io.literal.LiteralWriter;
import java.io.IOException;

public final class UDDISOAPHandler
implements IService,
ISOAPHandler,
IUDDIConstants,
IUDDIServerHolder,
ISOAPConstants {
    private IUDDIServer server;
    private String[] methods;

    public UDDISOAPHandler(IUDDIServer server, String[] methods) {
        this.server = server;
        this.methods = methods;
    }

    public IUDDIServer getUDDIServer() {
        return this.server;
    }

    private boolean understands(String method) {
        int i = 0;
        while (i < this.methods.length) {
            if (this.methods[i].equals(method)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public SOAPMessage handle(SOAPMessage request, Context context) throws SOAPException {
        SOAPMessage response;
        block7: {
            SOAPHeaders.checkHeaders(request, context);
            response = new SOAPMessage();
            String version = null;
            try {
                Element element = request.getBody().getFirstElement();
                version = element.getAttributeValue("generic");
                LiteralReader reader = new LiteralReader(element);
                IWriter writer = this.invoke(reader, version);
                writer.writeAttribute("generic", version);
                writer.writeNamespace("", version.equals("1.0") ? "urn:uddi-org:api" : "urn:uddi-org:api_v2");
                if (this.server.getOperator() != null) {
                    writer.writeAttribute("operator", this.server.getOperator());
                }
                Document document = new Document();
                Element envelope = document.newRoot();
                envelope.setNamespace("", "http://schemas.xmlsoap.org/soap/envelope/");
                envelope.setName("Envelope");
                Element body = envelope.addElement("Body");
                body.addElement(writer.getElement());
                response.setDocument(document);
            }
            catch (UDDIException exception) {
                if (version != null) {
                    exception.setVersion(version);
                }
                response.setException(exception);
            }
            catch (SOAPException exception) {
                response.setException(exception);
            }
            catch (Exception exception) {
                if (version != null) {
                    response.setException(new UDDIException(exception.toString(), version));
                    break block7;
                }
                response.setException(new UDDIException(exception.toString()));
            }
        }
        return response;
    }

    private IWriter invoke(IReader reader, String version) throws IOException {
        Object result;
        String method = reader.readName();
        if (!this.understands(method)) {
            throw new UDDIException(method + " is not understood");
        }
        ICommand command = (ICommand)Messages.newInstance(method);
        command.read(reader);
        Authorization authorization = null;
        if (command.needsAuthorization()) {
            String authInfo = reader.readString("authInfo");
            if (authInfo == null) {
                throw new UDDIException(10120);
            }
            authorization = new Authorization(authInfo);
        }
        if ((result = this.server.invoke(command, authorization)) == null) {
            result = IUDDIConstants.OK;
        }
        LiteralWriter writer = new LiteralWriter();
        ((ISerializable)result).write(writer);
        return writer;
    }

    public WSDL getWSDL() {
        return null;
    }

    public IReference getReference() {
        return null;
    }

    public Context getContext() {
        return new Context();
    }

    public void setContext(Context context) {
    }

    public ClassLoader getClassLoader() {
        return this.getClass().getClassLoader();
    }
}

