/*
 * Decompiled with CFR 0.152.
 */
package electric.soap.local.reference;

import electric.service.IService;
import electric.soap.ISOAPHandler;
import electric.soap.SOAPMessage;
import electric.soap.handlers.SOAPHandlerFactories;
import electric.soap.references.ISOAPReference;
import electric.util.Context;
import electric.util.XURL;
import electric.util.classloader.ClassLoaders;
import electric.util.classloader.IHasClassLoader;
import electric.wsdl.WSDL;
import java.rmi.RemoteException;

public class SOAPLocalTransport
implements ISOAPReference {
    private XURL endpoint;
    private IService service;

    public SOAPLocalTransport(XURL endpoint, IService service) {
        this.endpoint = endpoint;
        this.service = service;
    }

    public IService getService() {
        return this.service;
    }

    public WSDL getWSDL() {
        ClassLoader cl = ClassLoaders.getContextClassLoader();
        if (this.service instanceof IHasClassLoader) {
            ClassLoaders.setContextClassLoader(((IHasClassLoader)((Object)this.service)).getClassLoader());
        }
        WSDL wsdl = this.service.getWSDL();
        ClassLoaders.setContextClassLoader(cl);
        return wsdl;
    }

    public XURL getEndpoint() {
        return this.endpoint;
    }

    public ISOAPReference next() {
        return null;
    }

    public void setNext(ISOAPReference reference) {
    }

    public SOAPMessage handle(SOAPMessage soapRequest, Context messageContext) throws RemoteException, SecurityException {
        ISOAPHandler handlerChain = SOAPHandlerFactories.getSOAPHandlerChain(this.service);
        ClassLoader cl = ClassLoaders.getContextClassLoader();
        if (this.service instanceof IHasClassLoader) {
            ClassLoaders.setContextClassLoader(((IHasClassLoader)((Object)this.service)).getClassLoader());
        }
        Context serverMessageContext = new Context();
        serverMessageContext.setProperty("endpoint", this.endpoint);
        SOAPMessage message = handlerChain.handle(soapRequest, serverMessageContext);
        ClassLoaders.setContextClassLoader(cl);
        return message;
    }
}

