/*
 * Decompiled with CFR 0.152.
 */
package electric.servlet.authorizers.servlet;

import electric.glue.IGLUELoggingConstants;
import electric.security.IGuard;
import electric.security.IRealm;
import electric.servlet.HTTPContext;
import electric.servlet.InboundHTTPRequest;
import electric.servlet.OutboundHTTPResponse;
import electric.servlet.authorizers.IHTTPAuthorizer;
import electric.util.array.ArrayUtil;
import electric.util.http.IHTTPConstants;
import electric.util.log.Log;
import java.io.IOException;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletAuthorizer
implements IHTTPAuthorizer,
IHTTPConstants,
IGLUELoggingConstants {
    protected HTTPContext httpContext;

    public ServletAuthorizer(HTTPContext httpContext) {
        this.httpContext = httpContext;
    }

    public boolean authorize(HttpServletRequest request, HttpServletResponse response, String relativePath) throws IOException {
        return this.authorize((InboundHTTPRequest)request, (OutboundHTTPResponse)response, relativePath);
    }

    private String[] getAuthorizedUsers(InboundHTTPRequest request, IRealm realm) {
        String[] users = new String[]{};
        Enumeration enumeration = request.getHeaders("Authorization");
        while (enumeration.hasMoreElements()) {
            String authorization = (String)enumeration.nextElement();
            StringTokenizer tokenizer = new StringTokenizer(authorization);
            String authMethodRequested = tokenizer.nextToken();
            String authMethod = this.httpContext.getAuthMethod();
            if (!authMethod.equalsIgnoreCase(authMethodRequested)) continue;
            String[] authUsers = this.httpContext.authenticator.getAuthorizedUsers(request, realm, authorization);
            users = (String[])ArrayUtil.addElements(users, authUsers);
        }
        return users;
    }

    private boolean isAuthorized(IGuard guard, String[] users) {
        if (users == null) {
            return false;
        }
        if (this.httpContext == null || this.httpContext.getRealm() == null) {
            return false;
        }
        int i = 0;
        while (i < users.length) {
            try {
                guard.check(this.httpContext.getRealm(), users[i]);
                return true;
            }
            catch (SecurityException exception) {
                if (Log.isLogging(IGLUELoggingConstants.SECURITY_DEBUG_EVENT)) {
                    Log.log(IGLUELoggingConstants.SECURITY_DEBUG_EVENT, "ServletAuthorizer", exception);
                }
                ++i;
            }
        }
        return false;
    }

    private boolean authorize(InboundHTTPRequest request, OutboundHTTPResponse response, String requestURI) throws IOException {
        Enumeration guards = this.httpContext.getAllGuards(requestURI);
        if (!guards.hasMoreElements()) {
            return true;
        }
        if (this.httpContext.getRealm() == null) {
            return this.httpContext.authenticator.requestAuthentication(request, response, null);
        }
        String[] authUsers = this.getAuthorizedUsers(request, this.httpContext.getRealm());
        while (guards.hasMoreElements()) {
            if (this.isAuthorized((IGuard)guards.nextElement(), authUsers)) continue;
            return this.httpContext.authenticator.requestAuthentication(request, response, this.httpContext.getRealm());
        }
        return true;
    }
}

