/*
 * Decompiled with CFR 0.152.
 */
package electric.security.acl;

import electric.glue.IGLUELoggingConstants;
import electric.security.acl.ACLRealm;
import electric.security.acl.ExactFilter;
import electric.util.directory.monitored.IFileEventListener;
import electric.util.directory.monitored.MonitoredRoot;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import java.io.File;

public class ACLMonitor
implements IFileEventListener,
IGLUELoggingConstants {
    private MonitoredRoot root;
    private ACLRealm realm;

    public ACLMonitor(ACLRealm realm, String filename) {
        this.realm = realm;
        ExactFilter filter = new ExactFilter(filename);
        int lastSeparator = filename.lastIndexOf(File.separatorChar);
        String path = lastSeparator != -1 ? filename.substring(0, lastSeparator) : ".";
        this.root = new MonitoredRoot(new File(path), true, false, filter);
        this.root.cycle();
        this.root.addEventListener(this);
        this.root.start();
    }

    public void cycle() {
        this.root.cycle();
    }

    public void filesAdded(File[] files) {
        block2: {
            try {
                this.realm.sync();
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.SECURITY_EVENT)) break block2;
                Log.log(ILoggingConstants.SECURITY_EVENT, "realm file could not be parsed", throwable);
            }
        }
    }

    public void filesRemoved(File[] files) {
        this.realm.clear();
    }

    public void filesModified(File[] files) {
        block2: {
            try {
                this.realm.sync();
            }
            catch (Throwable throwable) {
                if (!Log.isLogging(ILoggingConstants.SECURITY_EVENT)) break block2;
                Log.log(ILoggingConstants.SECURITY_EVENT, "realm file could not be parsed", throwable);
            }
        }
    }

    public void stop() {
        this.root.removeAllListeners();
        this.root.stop();
    }
}

