/*
 * Decompiled with CFR 0.152.
 */
package electric.glue.context;

import electric.glue.IGLUEContextConstants;
import electric.http.cookies.ICookieListener;
import electric.soap.ISOAPInterceptor;
import electric.soap.security.WSSContext;
import electric.util.Context;
import electric.util.mime.IDataHandler;
import java.util.Enumeration;

public class ProxyContext
extends Context
implements IGLUEContextConstants {
    public void setAuthMethod(String type) {
        this.setProperty("authMethod", type);
    }

    public String getAuthMethod() {
        return this.getStringProperty("authMethod");
    }

    public void setDigestAuthMethod() {
        this.setAuthMethod("Digest");
    }

    public boolean isDigestAuthMethod() {
        return "Digest".equalsIgnoreCase(this.getAuthMethod());
    }

    public void setBasicAuthMethod() {
        this.setAuthMethod("Basic");
    }

    public boolean isBasicAuthMethod() {
        return "Basic".equalsIgnoreCase(this.getAuthMethod());
    }

    public void setAuthentication(String user, String password) {
        this.setAuthUser(user);
        this.setAuthPassword(password);
    }

    public void setAuthPassword(String password) {
        this.setProperty("authPassword", password);
    }

    public String getAuthPassword() {
        return this.getStringProperty("authPassword");
    }

    public void setAuthUser(String user) {
        this.setProperty("authUser", user);
    }

    public String getAuthUser() {
        return this.getStringProperty("authUser");
    }

    public void addCookieListener(ICookieListener listener) {
        this.addProperty("cookieListener", listener);
    }

    public Enumeration getCookieListeners() {
        return this.getProperties("cookieListener");
    }

    public void setDataDirectory(String directory) {
        this.setProperty("dataDirectory", directory);
    }

    public void setDataHandler(String contentType, IDataHandler handler) {
        this.setProperty(contentType + " " + "dataHandler", handler);
    }

    public void setEndpoint(String url) {
        this.setProperty("endpoint", url);
    }

    public String getEndpoint() {
        return this.getStringProperty("endpoint");
    }

    public void setClientSocketReadTimeout(int milliseconds) {
        this.setProperty("clientSocketReadTimeout", new Integer(milliseconds));
    }

    public int getClientSocketReadTimeout() {
        Integer timeout = (Integer)this.getProperty("clientSocketReadTimeout");
        if (timeout == null) {
            return -1;
        }
        return timeout;
    }

    public void setKeepAlive(boolean flag) {
        this.setProperty("keepAlive", flag ? "true" : "false");
    }

    public boolean isKeepAlive() {
        return this.getBooleanProperty("keepAlive", true);
    }

    public void setProxy(String hostname, int port, String user, String password) {
        this.setProxyHost(hostname);
        this.setProxyPort(port);
        this.setProxyUser(user);
        this.setProxyPassword(password);
    }

    public void setProxyHost(String hostname) {
        this.setProperty("httpProxyHost", hostname);
    }

    public String getProxyHost() {
        return this.getStringProperty("httpProxyHost");
    }

    public void setProxyPort(int port) {
        this.setProperty("httpProxyPort", Integer.toString(port));
    }

    public int getProxyPort() {
        return this.getIntProperty("httpProxyPort", -1);
    }

    public void setProxyUser(String user) {
        this.setProperty("httpProxyUser", user);
    }

    public String getProxyUser() {
        return this.getStringProperty("httpProxyUser");
    }

    public void setProxyPassword(String password) {
        this.setProperty("httpProxyPassword", password);
    }

    public String getProxyPassword() {
        return this.getStringProperty("httpProxyPassword");
    }

    public void addInboundSoapResponseInterceptor(ISOAPInterceptor interceptor) {
        this.addProperty("inboundSoapResponseInterceptor", interceptor);
    }

    public Enumeration getInboundSoapResponseInterceptors() {
        return this.getProperties("inboundSoapResponseInterceptor");
    }

    public void addOutboundSoapRequestInterceptor(ISOAPInterceptor interceptor) {
        this.addProperty("outboundSoapRequestInterceptor", interceptor);
    }

    public Enumeration getOutboundSoapRequestInterceptors() {
        return this.getProperties("outboundSoapRequestInterceptor");
    }

    public String getRPNamespace() {
        return (String)this.getProperty("rpNamespace");
    }

    public void setRPNamespace(String rpNamespace) {
        this.setProperty("rpNamespace", rpNamespace);
    }

    public Enumeration getForwardIntermediaries() {
        return this.getProperties("fwdRoute");
    }

    public void addForwardIntermediary(String intermediary) {
        this.addProperty("fwdRoute", intermediary);
    }

    public String getClientID() {
        return (String)this.getProperty("clientId");
    }

    public void setClientID(String soapActor) {
        this.setProperty("clientId", soapActor);
    }

    public void setXMLEncoding(String encoding) {
        this.setProperty("xmlEncoding", encoding);
    }

    public String getXMLEncoding() {
        return this.getStringProperty("xmlEncoding");
    }

    public void setWSSContext(WSSContext context) {
        this.setProperty("wssContext", context);
    }

    public WSSContext getWSSContext() {
        return (WSSContext)this.getProperty("wssContext");
    }

    public void setStyle(String style) {
        this.setProperty("style", style);
    }

    public void setDocumentStyle() {
        this.setStyle("document");
    }

    public void setRPCStyle() {
        this.setStyle("rpc");
    }

    public String getStyle() {
        return this.getStringProperty("style");
    }
}

