/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.services.selection;

import electric.fabric.Fabric;
import electric.fabric.IFabricConstants;
import electric.fabric.services.IServiceManager;
import electric.fabric.services.IServiceSelector;
import electric.fabric.services.ServiceInfo;
import electric.fabric.services.ServiceManagerException;
import electric.fabric.services.ServicePath;
import electric.server.Servers;
import electric.util.XURL;
import electric.util.array.ArrayUtil;
import electric.util.http.HTTPUtil;

public class ServiceSelector
implements IServiceSelector,
IFabricConstants {
    private IServiceManager serviceManager;

    public ServiceSelector(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    public ServicePath selectService(String path, XURL[] intermediaries) throws ServiceManagerException {
        try {
            String wsdlURL = HTTPUtil.getParameter(path, "service.wsdl");
            intermediaries = (XURL[])ArrayUtil.randomizeOrder(intermediaries);
            if (wsdlURL != null) {
                return this.selectServiceUsingWSDL(path, wsdlURL, intermediaries);
            }
            return this.selectServiceUsingConstraint(path, intermediaries);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ServicePath selectServiceUsingWSDL(String path, String wsdlURL, XURL[] intermediaries) throws Exception {
        if (HTTPUtil.hasParameter(path, "system")) {
            return new ServicePath(new ServiceInfo(wsdlURL));
        }
        ServiceInfo serviceInfo = this.serviceManager.getServiceInfoForWSDL(wsdlURL);
        if (serviceInfo == null) {
            serviceInfo = new ServiceInfo(wsdlURL);
            this.serviceManager.publishUsingInfo(serviceInfo);
        }
        if (!Fabric.needsFabricFunctionality(path)) {
            return new ServicePath(serviceInfo);
        }
        if (serviceInfo.getMetadata("inFabricServer") != null) {
            return new ServicePath(serviceInfo);
        }
        if (intermediaries.length == 0) {
            return null;
        }
        XURL endpointHostAndPortXURL = serviceInfo.getEndpointXURL().getHostAndPortXURL();
        int i = 0;
        while (i < intermediaries.length) {
            if (intermediaries[i].getHostAndPortXURL().equals(endpointHostAndPortXURL)) {
                return new ServicePath(serviceInfo, intermediaries[i]);
            }
            ++i;
        }
        return new ServicePath(serviceInfo, intermediaries[0]);
    }

    private ServicePath selectServiceUsingConstraint(String path, XURL[] intermediaries) throws ServiceManagerException {
        ServiceInfo constraint = this.serviceManager.getConstraint(path, true);
        ServiceInfo[] serviceInfos = this.serviceManager.findServicesForConstraint(constraint);
        serviceInfos = (ServiceInfo[])ArrayUtil.randomizeOrder(serviceInfos);
        while (serviceInfos.length > 0) {
            ServicePath selectedPath = this.selectBestPath(path, serviceInfos, intermediaries);
            if (selectedPath == null) {
                return null;
            }
            ServiceInfo serviceInfo = selectedPath.getServiceInfo();
            if (serviceInfo.getWSDL() != null) {
                return selectedPath;
            }
            serviceInfos = (ServiceInfo[])ArrayUtil.removeElement(serviceInfos, serviceInfo);
        }
        return null;
    }

    private ServicePath selectBestPath(String path, ServiceInfo[] serviceInfos, XURL[] intermediaries) {
        int i = 0;
        while (i < serviceInfos.length) {
            if (Servers.isLocal(serviceInfos[i].getWSDLXURL())) {
                return new ServicePath(serviceInfos[i]);
            }
            ++i;
        }
        if (!Fabric.needsFabricFunctionality(path)) {
            return new ServicePath(serviceInfos[0]);
        }
        int i2 = 0;
        while (i2 < serviceInfos.length) {
            if (serviceInfos[i2].getMetadata("inFabricServer") != null) {
                return new ServicePath(serviceInfos[i2]);
            }
            ++i2;
        }
        if (intermediaries.length == 0) {
            return null;
        }
        int i3 = 0;
        while (i3 < serviceInfos.length) {
            int j = 0;
            while (j < intermediaries.length) {
                if (intermediaries[j].getHostAndPortXURL().equals(serviceInfos[i3].getHostAndPortXURL())) {
                    return new ServicePath(serviceInfos[i3], intermediaries[j]);
                }
                ++j;
            }
            ++i3;
        }
        return new ServicePath(serviceInfos[0], intermediaries[0]);
    }
}

