/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.rules.conditions.xpath;

import electric.fabric.rules.conditions.IUnaryCondition;
import electric.soap.SOAPMessage;
import electric.util.Context;
import electric.util.array.ArrayUtil;
import electric.xml.IXPath;
import electric.xml.IXPathFactory;
import electric.xml.Parent;
import electric.xml.XPath;

public class XPathMatch
implements IUnaryCondition {
    public static final int MESSAGE = 0;
    public static final String MESSAGE_STRING = "message";
    public static final int BODY = 1;
    public static final String BODY_STRING = "body";
    public static final int HEADER = 2;
    public static final String HEADER_STRING = "header";
    private static IXPathFactory xpathFactory;
    public int mode = 0;
    public String path;
    public String[] prefixes = new String[0];
    public String[] namespaces = new String[0];
    private transient IXPath xpath;

    public XPathMatch() {
    }

    public XPathMatch(String path) {
        this(path, 0);
    }

    public XPathMatch(String path, int mode) {
        this.path = path;
        this.mode = mode;
        this.initNamespaces();
    }

    public XPathMatch(String path, String mode) {
        this.path = path;
        this.mode = this.getMode(mode);
        this.initNamespaces();
    }

    public String toString() {
        return "XPathMatch( path=" + this.path + ", mode=" + this.getMode() + " )";
    }

    public String getMode() {
        if (this.mode == 0) {
            return MESSAGE_STRING;
        }
        if (this.mode == 1) {
            return BODY_STRING;
        }
        if (this.mode == 2) {
            return HEADER_STRING;
        }
        return "unknown";
    }

    public int getMode(String mode) {
        if (mode.equalsIgnoreCase(MESSAGE_STRING)) {
            return 0;
        }
        if (mode.equalsIgnoreCase(BODY_STRING)) {
            return 1;
        }
        if (mode.equalsIgnoreCase(HEADER_STRING)) {
            return 2;
        }
        return -1;
    }

    private void initNamespaces() {
        this.addNamespace("soap", "http://schemas.xmlsoap.org/soap/envelope/");
        this.addNamespace("xsi2001", "http://www.w3.org/2001/XMLSchema-instance");
        this.addNamespace("xsd2001", "http://www.w3.org/2001/XMLSchema");
        this.addNamespace("soapenc", "http://schemas.xmlsoap.org/soap/encoding/");
    }

    public void addNamespace(String prefix, String namespace) {
        this.prefixes = (String[])ArrayUtil.addElement(this.prefixes, prefix);
        this.namespaces = (String[])ArrayUtil.addElement(this.namespaces, namespace);
    }

    private static synchronized IXPathFactory getXPathFactory() {
        if (xpathFactory != null) {
            return xpathFactory;
        }
        xpathFactory = XPath.getFactory(1);
        if (xpathFactory == null) {
            System.out.println("COULD NOT CREATE FULL XPATH FACTORY");
        }
        return xpathFactory;
    }

    public synchronized IXPath getXPath() {
        if (this.xpath != null) {
            return this.xpath;
        }
        this.xpath = XPathMatch.getXPathFactory().newCachedXPath(this.path, null);
        int i = 0;
        while (i < this.prefixes.length) {
            this.xpath.setNamespace(this.prefixes[i], this.namespaces[i]);
            ++i;
        }
        return this.xpath;
    }

    public boolean satisfiedBy(SOAPMessage message, Context messageContext) {
        Parent root = null;
        if (this.mode == 0) {
            root = message.getDocument();
        } else if (this.mode == 1) {
            root = message.getBody();
        } else if (this.mode == 2) {
            root = message.getHeader();
        }
        return this.getXPath().getBoolean(root);
    }
}

