/*
 * Decompiled with CFR 0.152.
 */
package electric.fabric.intermediary;

import electric.fabric.IFabricConstants;
import electric.servlet.util.HTTPServletUtil;
import electric.util.http.HTTPUtil;
import electric.util.http.IHTTPConstants;
import electric.util.log.ILoggingConstants;
import electric.util.log.Log;
import electric.xdb.Data;
import electric.xdb.client.IXDBClient;
import electric.xdb.client.XDBClients;
import electric.xml.Element;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class XDBHandler
extends HttpServlet
implements IHTTPConstants,
IFabricConstants,
ILoggingConstants {
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String queryString = request.getQueryString();
        if (queryString == null) {
            queryString = (String)request.getAttribute("queryString");
        }
        queryString = "?" + queryString;
        try {
            String database = HTTPUtil.getParameter(queryString, "database");
            String key = HTTPUtil.getParameter(queryString, "key");
            boolean body = HTTPUtil.hasParameter(queryString, "body");
            IXDBClient client = XDBClients.getClient(database);
            Data data = client.getDataForKey(key);
            if (data == null) {
                throw new IllegalArgumentException(queryString);
            }
            Element element = body ? data.getBody().getFirstElement() : data.getEnvelope();
            byte[] bytes = element.getBytes();
            response.setContentType("text/xml");
            response.setStatus(200);
            response.setHeader("Server", IHTTPConstants.SERVER_TYPE);
            HTTPServletUtil.writeContent(request, response, bytes);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (Log.isLogging(ILoggingConstants.EXCEPTION_EVENT)) {
                Log.log(ILoggingConstants.EXCEPTION_EVENT, (Throwable)exception);
            }
            response.sendError(404, "cannot find data for " + queryString);
        }
    }
}

