/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.Action;
import webwork.action.factory.JavaActionFactory;
import webwork.config.Configuration;
import webwork.util.ClassLoaderUtils;
import webwork.util.classloader.WebworkClassLoader;
import webwork.util.injection.ObjectFactory;

public class ReloadingJavaActionFactory
extends JavaActionFactory {
    private static final Log log = LogFactory.getLog(ReloadingJavaActionFactory.class);
    private WebworkClassLoader reloadingClassLoader;
    private URL source;

    public ReloadingJavaActionFactory() {
        URL url = this.getClass().getResource("/webwork.properties");
        if (url == null) {
            log.warn((Object)"Cannot find CodeSource for webwork, unable to creare reloading action factory");
        } else {
            try {
                String urlVal = url.toString();
                this.source = new URL(urlVal.substring(0, urlVal.lastIndexOf("webwork.properties")));
                log.debug((Object)("Creating classloader for url " + this.source));
                WebworkClassLoader actionLoader = WebworkClassLoader.getInstance(this.source, Thread.currentThread().getContextClassLoader());
                StringTokenizer tok = new StringTokenizer(Configuration.getString("webwork.action.packages").trim(), ", ");
                String[] packages = new String[tok.countTokens()];
                int counter = 0;
                while (tok.hasMoreTokens()) {
                    packages[counter++] = tok.nextToken();
                }
                actionLoader.setPackages(packages);
                this.actionLoader = actionLoader;
                this.reloadingClassLoader = actionLoader;
            }
            catch (MalformedURLException ex) {
                log.error((Object)"Grr", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Action getActionImpl(String name) throws Exception {
        if (this.reloadingClassLoader != null && this.reloadingClassLoader.isStale()) {
            ReloadingJavaActionFactory reloadingJavaActionFactory = this;
            synchronized (reloadingJavaActionFactory) {
                log.debug((Object)"Classes modified, reloading...");
                this.reloadingClassLoader = (WebworkClassLoader)this.reloadingClassLoader.clone();
                this.actionLoader = this.reloadingClassLoader;
            }
        }
        Class<Object> actionClass = null;
        try {
            actionClass = this.reloadingClassLoader.loadClass(name);
        }
        catch (Exception e) {
            try {
                actionClass = ClassLoaderUtils.loadClass(name, this.getClass());
            }
            catch (Exception e2) {
                throw new IllegalArgumentException("Action '" + name + "' not found");
            }
        }
        try {
            Action action = (Action)ObjectFactory.instantiate(actionClass);
            return action;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Action '" + name + "' could not be instantiated:" + e);
        }
    }
}

