/*
 * Decompiled with CFR 0.152.
 */
package webwork.action.factory;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import webwork.action.Action;
import webwork.action.factory.ActionFactory;
import webwork.action.factory.ActionFactoryProxy;
import webwork.config.Configuration;
import webwork.util.ClassLoaderUtils;

public class ReloadHelperActionFactoryProxy
extends ActionFactoryProxy {
    private File[] files;
    private long[] lastModified;

    public ReloadHelperActionFactoryProxy(ActionFactory aFactory) {
        super(aFactory);
        StringTokenizer configFiles = new StringTokenizer((String)Configuration.get("webwork.configuration.xml"), ",");
        ArrayList<File> l = new ArrayList<File>(configFiles.countTokens());
        while (configFiles.hasMoreTokens()) {
            File file;
            String name = configFiles.nextToken();
            URL fileUrl = ClassLoaderUtils.getResource(name + ".xml", ReloadHelperActionFactoryProxy.class);
            if (fileUrl == null || !(file = new File(fileUrl.getFile())).exists()) continue;
            l.add(file);
        }
        this.files = new File[l.size()];
        l.toArray(this.files);
        this.lastModified = new long[this.files.length];
        for (int i = 0; i < this.files.length; ++i) {
            this.lastModified[i] = this.files[i].lastModified();
        }
    }

    public Action getActionImpl(String aName) throws Exception {
        for (int i = 0; i < this.files.length; ++i) {
            if (this.files[i].lastModified() <= this.lastModified[i]) continue;
            this.lastModified[i] = this.files[i].lastModified();
            this.flushCaches();
        }
        return this.getNextFactory().getActionImpl(aName);
    }
}

