/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime;

import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.io.StringReader;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.directive.VelocimacroProxy;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocimacroManager {
    private static String GLOBAL_NAMESPACE = "";
    private final RuntimeServices rsvc;
    private final ConcurrentMap<String, ConcurrentMap<String, MacroEntry>> namespaceHash = CopyOnWriteMap.newHashMap();
    private final Map<String, String> libraryMap = CopyOnWriteMap.newHashMap();
    private volatile boolean namespacesOn = true;
    private volatile boolean inlineLocalMode = false;
    private volatile boolean registerFromLib = false;

    VelocimacroManager(RuntimeServices rs) {
        this.rsvc = rs;
        this.addNamespace(GLOBAL_NAMESPACE);
    }

    public boolean addVM(String vmName, String macroBody, String[] argArray, String namespace) {
        MacroEntry me = new MacroEntry(this, vmName, macroBody, argArray, namespace);
        me.setFromLibrary(this.registerFromLib);
        boolean isLib = true;
        if (this.registerFromLib) {
            this.libraryMap.put(namespace, namespace);
        } else {
            isLib = this.libraryMap.containsKey(namespace);
        }
        if (!isLib && this.usingNamespaces(namespace)) {
            this.getNamespace(namespace, true).putIfAbsent(vmName, me);
            return true;
        }
        MacroEntry exist = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (exist != null) {
            me.setFromLibrary(exist.getFromLibrary());
        }
        this.getNamespace(GLOBAL_NAMESPACE).putIfAbsent(vmName, me);
        return true;
    }

    public VelocimacroProxy get(String vmName, String namespace) {
        MacroEntry me;
        ConcurrentMap<String, MacroEntry> local;
        if (this.usingNamespaces(namespace) && (local = this.getNamespace(namespace, false)) != null && (me = (MacroEntry)local.get(vmName)) != null) {
            return me.createVelocimacro(namespace);
        }
        MacroEntry me2 = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (me2 != null) {
            return me2.createVelocimacro(namespace);
        }
        return null;
    }

    public boolean dumpNamespace(String namespace) {
        if (this.usingNamespaces(namespace)) {
            Map h = (Map)this.namespaceHash.remove(namespace);
            if (h == null) {
                return false;
            }
            h.clear();
            return true;
        }
        return false;
    }

    public void setNamespaceUsage(boolean b) {
        this.namespacesOn = b;
    }

    public void setRegisterFromLib(boolean b) {
        this.registerFromLib = b;
    }

    public void setTemplateLocalInlineVM(boolean b) {
        this.inlineLocalMode = b;
    }

    private ConcurrentMap<String, MacroEntry> getNamespace(String namespace) {
        return this.getNamespace(namespace, false);
    }

    private ConcurrentMap<String, MacroEntry> getNamespace(String namespace, boolean addIfNew) {
        ConcurrentMap<String, MacroEntry> h = (ConcurrentMap<String, MacroEntry>)this.namespaceHash.get(namespace);
        if (h == null && addIfNew) {
            h = this.addNamespace(namespace);
        }
        return h;
    }

    private ConcurrentMap<String, MacroEntry> addNamespace(String namespace) {
        CopyOnWriteMap h = CopyOnWriteMap.newHashMap();
        if (this.namespaceHash.putIfAbsent(namespace, (ConcurrentMap<String, MacroEntry>)h) != null) {
            return null;
        }
        return h;
    }

    private boolean usingNamespaces(String namespace) {
        if (!this.namespacesOn) {
            return false;
        }
        return this.inlineLocalMode;
    }

    public String getLibraryName(String vmName, String namespace) {
        MacroEntry me;
        ConcurrentMap<String, MacroEntry> local;
        if (this.usingNamespaces(namespace) && (local = this.getNamespace(namespace, false)) != null && (me = (MacroEntry)local.get(vmName)) != null) {
            return null;
        }
        MacroEntry me2 = (MacroEntry)this.getNamespace(GLOBAL_NAMESPACE).get(vmName);
        if (me2 != null) {
            return me2.getSourceTemplate();
        }
        return null;
    }

    protected class MacroEntry {
        String macroname;
        String[] argarray;
        String macrobody;
        String sourcetemplate;
        SimpleNode nodeTree = null;
        VelocimacroManager manager = null;
        boolean fromLibrary = false;

        MacroEntry(VelocimacroManager vmm, String vmName, String macroBody, String[] argArray, String sourceTemplate) {
            this.macroname = vmName;
            this.argarray = argArray;
            this.macrobody = macroBody;
            this.sourcetemplate = sourceTemplate;
            this.manager = vmm;
        }

        public void setFromLibrary(boolean b) {
            this.fromLibrary = b;
        }

        public boolean getFromLibrary() {
            return this.fromLibrary;
        }

        public SimpleNode getNodeTree() {
            return this.nodeTree;
        }

        public String getSourceTemplate() {
            return this.sourcetemplate;
        }

        VelocimacroProxy createVelocimacro(String namespace) {
            VelocimacroProxy vp = new VelocimacroProxy();
            vp.setName(this.macroname);
            vp.setArgArray(this.argarray);
            vp.setMacrobody(this.macrobody);
            vp.setNodeTree(this.nodeTree);
            vp.setNamespace(namespace);
            return vp;
        }

        void setup(InternalContextAdapter ica) {
            if (this.nodeTree == null) {
                this.parseTree(ica);
            }
        }

        void parseTree(InternalContextAdapter ica) {
            try {
                StringReader br = new StringReader(this.macrobody);
                this.nodeTree = VelocimacroManager.this.rsvc.parse(br, "VM:" + this.macroname, true);
                this.nodeTree.init(ica, null);
            }
            catch (Exception e) {
                VelocimacroManager.this.rsvc.error("VelocimacroManager.parseTree() : exception " + this.macroname + " : " + StringUtils.stackTrace(e));
            }
        }
    }
}

