/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web.descriptors;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.loaders.LoaderUtils;
import com.atlassian.plugin.web.Condition;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.conditions.AbstractCompositeCondition;
import com.atlassian.plugin.web.conditions.AndCompositeCondition;
import com.atlassian.plugin.web.conditions.InvertedCondition;
import com.atlassian.plugin.web.conditions.OrCompositeCondition;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.model.DefaultWebLabel;
import com.atlassian.plugin.web.model.DefaultWebParam;
import com.atlassian.plugin.web.model.WebLabel;
import com.atlassian.plugin.web.model.WebParam;
import java.util.List;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebFragmentModuleDescriptor<T>
extends AbstractModuleDescriptor<T>
implements StateAware,
WebFragmentModuleDescriptor<T> {
    protected WebInterfaceManager webInterfaceManager;
    protected Element element;
    protected int weight;
    protected Condition condition;
    protected ContextProvider contextProvider;
    protected DefaultWebLabel label;
    protected DefaultWebLabel tooltip;
    protected WebParam params;

    protected AbstractWebFragmentModuleDescriptor(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public AbstractWebFragmentModuleDescriptor() {
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.element = element;
        this.weight = 1000;
        try {
            this.weight = Integer.parseInt(element.attributeValue("weight"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Condition makeConditions(Element element, int type) throws PluginParseException {
        List singleConditionElements = element.elements("condition");
        Condition singleConditions = null;
        if (singleConditionElements != null && !singleConditionElements.isEmpty()) {
            singleConditions = this.makeConditions(singleConditionElements, type);
        }
        List nestedConditionsElements = element.elements("conditions");
        AbstractCompositeCondition nestedConditions = null;
        if (nestedConditionsElements != null && !nestedConditionsElements.isEmpty()) {
            nestedConditions = this.getCompositeCondition(type);
            for (Element nestedElement : nestedConditionsElements) {
                nestedConditions.addCondition(this.makeConditions(nestedElement, this.getCompositeType(nestedElement.attributeValue("type"))));
            }
        }
        if (singleConditions != null && nestedConditions != null) {
            AbstractCompositeCondition compositeCondition = this.getCompositeCondition(type);
            compositeCondition.addCondition(singleConditions);
            compositeCondition.addCondition(nestedConditions);
            return compositeCondition;
        }
        if (singleConditions != null) {
            return singleConditions;
        }
        if (nestedConditions != null) {
            return nestedConditions;
        }
        return null;
    }

    protected Condition makeConditions(List elements, int type) throws PluginParseException {
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() == 1) {
            return this.makeCondition((Element)elements.get(0));
        }
        AbstractCompositeCondition compositeCondition = this.getCompositeCondition(type);
        for (Element element : elements) {
            compositeCondition.addCondition(this.makeCondition(element));
        }
        return compositeCondition;
    }

    protected Condition makeCondition(Element element) throws PluginParseException {
        try {
            Condition condition = this.webInterfaceManager.getWebFragmentHelper().loadCondition(element.attributeValue("class"), this.plugin);
            condition.init(LoaderUtils.getParams((Element)element));
            if (element.attribute("invert") != null && "true".equals(element.attributeValue("invert"))) {
                return new InvertedCondition(condition);
            }
            return condition;
        }
        catch (ClassCastException e) {
            throw new PluginParseException("Configured condition class does not implement the Condition interface");
        }
        catch (Throwable t) {
            throw new PluginParseException(t);
        }
    }

    protected ContextProvider makeContextProvider(Element element) throws PluginParseException {
        try {
            ContextProvider context = this.webInterfaceManager.getWebFragmentHelper().loadContextProvider(element.attributeValue("class"), this.plugin);
            context.init(LoaderUtils.getParams((Element)element));
            return context;
        }
        catch (ClassCastException e) {
            throw new PluginParseException("Configured context-provider class does not implement the ContextProvider interface");
        }
        catch (Throwable t) {
            throw new PluginParseException(t);
        }
    }

    private int getCompositeType(String type) throws PluginParseException {
        if ("or".equalsIgnoreCase(type)) {
            return 0;
        }
        if ("and".equalsIgnoreCase(type)) {
            return 1;
        }
        throw new PluginParseException("Invalid condition type specified. type = " + type);
    }

    private AbstractCompositeCondition getCompositeCondition(int type) throws PluginParseException {
        switch (type) {
            case 0: {
                return new OrCompositeCondition();
            }
            case 1: {
                return new AndCompositeCondition();
            }
        }
        throw new PluginParseException("Invalid condition type specified. type = " + type);
    }

    public void enabled() {
        super.enabled();
        try {
            if (this.element.element("context-provider") != null) {
                this.contextProvider = this.makeContextProvider(this.element.element("context-provider"));
            }
            if (this.element.element("label") != null) {
                this.label = new DefaultWebLabel(this.element.element("label"), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this);
            }
            if (this.element.element("tooltip") != null) {
                this.tooltip = new DefaultWebLabel(this.element.element("tooltip"), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this);
            }
            if (this.getParams() != null) {
                this.params = new DefaultWebParam(this.getParams(), this.webInterfaceManager.getWebFragmentHelper(), this.contextProvider, (WebFragmentModuleDescriptor)this);
            }
            this.condition = this.makeConditions(this.element, 1);
        }
        catch (PluginParseException e) {
            throw new RuntimeException("Unable to enable web fragment", e);
        }
        this.webInterfaceManager.refresh();
    }

    public void disabled() {
        this.webInterfaceManager.refresh();
        super.disabled();
    }

    @Override
    public int getWeight() {
        return this.weight;
    }

    @Override
    public WebLabel getWebLabel() {
        return this.label;
    }

    @Override
    public WebLabel getTooltip() {
        return this.tooltip;
    }

    public void setWebInterfaceManager(WebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public ContextProvider getContextProvider() {
        return this.contextProvider;
    }

    @Override
    public WebParam getWebParams() {
        return this.params;
    }
}

