/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilProperties;
import org.ofbiz.core.util.UtilURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class UtilXml {
    public static final String module = UtilXml.class.getName();

    public static String writeXmlDocument(Document document) throws IOException {
        if (document == null) {
            Debug.logWarning("[UtilXml.writeXmlDocument] Document was null, doing nothing", module);
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        UtilXml.writeXmlDocument(bos, document);
        String outString = bos.toString("UTF-8");
        if (bos != null) {
            bos.close();
        }
        return outString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXmlDocument(String filename, Document document) throws FileNotFoundException, IOException {
        if (document == null) {
            Debug.logWarning("[UtilXml.writeXmlDocument] Document was null, doing nothing", module);
            return;
        }
        if (filename == null) {
            Debug.logWarning("[UtilXml.writeXmlDocument] Filename was null, doing nothing", module);
            return;
        }
        File outFile = new File(filename);
        FileOutputStream fos = null;
        fos = new FileOutputStream(outFile);
        try {
            UtilXml.writeXmlDocument(fos, document);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static void writeXmlDocument(OutputStream os, Document document) throws IOException {
        if (document == null) {
            Debug.logWarning("[UtilXml.writeXmlDocument] Document was null, doing nothing", module);
            return;
        }
        if (os == null) {
            Debug.logWarning("[UtilXml.writeXmlDocument] OutputStream was null, doing nothing", module);
            return;
        }
        OutputFormat format = new OutputFormat(document);
        format.setIndent(2);
        XMLSerializer serializer = new XMLSerializer(os, format);
        serializer.asDOMSerializer();
        serializer.serialize(document.getDocumentElement());
    }

    public static Document readXmlDocument(String content) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(content, true);
    }

    public static Document readXmlDocument(String content, boolean validate) throws SAXException, ParserConfigurationException, IOException {
        if (content == null) {
            Debug.logWarning("[UtilXml.readXmlDocument] content was null, doing nothing", module);
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(content.getBytes("UTF-8"));
        return UtilXml.readXmlDocument(bis, validate, "Internal Content");
    }

    public static Document readXmlDocument(URL url) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(url, true);
    }

    public static Document readXmlDocument(URL url, boolean validate) throws SAXException, ParserConfigurationException, IOException {
        if (url == null) {
            Debug.logWarning("[UtilXml.readXmlDocument] URL was null, doing nothing", module);
            return null;
        }
        return UtilXml.readXmlDocument(url.openStream(), validate, url.toString());
    }

    public static Document readXmlDocument(InputStream is) throws SAXException, ParserConfigurationException, IOException {
        return UtilXml.readXmlDocument(is, true, null);
    }

    public static Document readXmlDocument(InputStream is, boolean validate, String docDescription) throws SAXException, ParserConfigurationException, IOException {
        if (is == null) {
            Debug.logWarning("[UtilXml.readXmlDocument] InputStream was null, doing nothing", module);
            return null;
        }
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validate);
        DocumentBuilder builder = factory.newDocumentBuilder();
        if (validate) {
            LocalResolver lr = new LocalResolver(new DefaultHandler());
            LocalErrorHandler eh = new LocalErrorHandler(docDescription, lr);
            builder.setEntityResolver(lr);
            builder.setErrorHandler(eh);
        }
        document = builder.parse(is);
        return document;
    }

    public static Document makeEmptyXmlDocument() {
        return UtilXml.makeEmptyXmlDocument(null);
    }

    public static Document makeEmptyXmlDocument(String rootElementName) {
        Document document = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
        }
        catch (Exception e) {
            Debug.logError(e, module);
        }
        if (document == null) {
            return null;
        }
        if (rootElementName != null) {
            Element rootElement = document.createElement(rootElementName);
            document.appendChild(rootElement);
        }
        return document;
    }

    public static Element addChildElement(Element element, String childElementName, Document document) {
        Element newElement = document.createElement(childElementName);
        element.appendChild(newElement);
        return newElement;
    }

    public static Element addChildElementValue(Element element, String childElementName, String childElementValue, Document document) {
        Element newElement = UtilXml.addChildElement(element, childElementName, document);
        newElement.appendChild(document.createTextNode(childElementValue));
        return newElement;
    }

    public static Element addChildElementCDATAValue(Element element, String childElementName, String childElementValue, Document document) {
        Element newElement = UtilXml.addChildElement(element, childElementName, document);
        newElement.appendChild(document.createCDATASection(childElementValue));
        return newElement;
    }

    public static List childElementList(Element element, String childElementName) {
        if (element == null) {
            return null;
        }
        LinkedList<Element> elements = new LinkedList<Element>();
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1 || childElementName != null && !childElementName.equals(node.getNodeName())) continue;
                Element childElement = (Element)node;
                elements.add(childElement);
            } while ((node = node.getNextSibling()) != null);
        }
        return elements;
    }

    public static Element firstChildElement(Element element, String childElementName) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                if (node.getNodeType() != 1 || childElementName != null && !childElementName.equals(node.getNodeName())) continue;
                Element childElement = (Element)node;
                return childElement;
            } while ((node = node.getNextSibling()) != null);
        }
        return null;
    }

    public static Element firstChildElement(Element element, String childElementName, String attrName, String attrValue) {
        if (element == null) {
            return null;
        }
        Node node = element.getFirstChild();
        if (node != null) {
            do {
                Element childElement;
                String value;
                if (node.getNodeType() != 1 || childElementName != null && !childElementName.equals(node.getNodeName()) || (value = (childElement = (Element)node).getAttribute(attrName)) == null || !value.equals(attrValue)) continue;
                return childElement;
            } while ((node = node.getNextSibling()) != null);
        }
        return null;
    }

    public static String childElementValue(Element element, String childElementName) {
        if (element == null) {
            return null;
        }
        Element childElement = UtilXml.firstChildElement(element, childElementName);
        return UtilXml.elementValue(childElement);
    }

    public static String childElementValue(Element element, String childElementName, String defaultValue) {
        if (element == null) {
            return defaultValue;
        }
        Element childElement = UtilXml.firstChildElement(element, childElementName);
        String elementValue = UtilXml.elementValue(childElement);
        if (elementValue == null || elementValue.length() == 0) {
            return defaultValue;
        }
        return elementValue;
    }

    public static String elementValue(Element element) {
        if (element == null) {
            return null;
        }
        element.normalize();
        Node textNode = element.getFirstChild();
        if (textNode == null) {
            return null;
        }
        return textNode.getNodeValue();
    }

    public static String checkEmpty(String string) {
        if (string != null && string.length() > 0) {
            return string;
        }
        return "";
    }

    public static String checkEmpty(String string1, String string2) {
        if (string1 != null && string1.length() > 0) {
            return string1;
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return "";
    }

    public static String checkEmpty(String string1, String string2, String string3) {
        if (string1 != null && string1.length() > 0) {
            return string1;
        }
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        if (string3 != null && string3.length() > 0) {
            return string3;
        }
        return "";
    }

    public static boolean checkBoolean(String str) {
        return UtilXml.checkBoolean(str, false);
    }

    public static boolean checkBoolean(String str, boolean defaultValue) {
        if (defaultValue) {
            return !"false".equals(str);
        }
        return "true".equals(str);
    }

    public static class LocalErrorHandler
    implements ErrorHandler {
        private String docDescription;
        private LocalResolver localResolver;

        public LocalErrorHandler(String docDescription, LocalResolver localResolver) {
            this.docDescription = docDescription;
            this.localResolver = localResolver;
        }

        public void error(SAXParseException exception) {
            if (this.localResolver.hasDTD()) {
                Debug.logError("XmlFileLoader: File " + this.docDescription + " process error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage(), module);
            }
        }

        public void fatalError(SAXParseException exception) {
            if (this.localResolver.hasDTD()) {
                Debug.logError("XmlFileLoader: File " + this.docDescription + " process fatal error. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage(), module);
            }
        }

        public void warning(SAXParseException exception) {
            if (this.localResolver.hasDTD()) {
                Debug.logError("XmlFileLoader: File " + this.docDescription + " process warning. Line: " + String.valueOf(exception.getLineNumber()) + ". Error message: " + exception.getMessage(), module);
            }
        }
    }

    public static class LocalResolver
    implements EntityResolver {
        private boolean hasDTD = false;
        private EntityResolver defaultResolver;

        public LocalResolver(EntityResolver defaultResolver) {
            this.defaultResolver = defaultResolver;
        }

        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            this.hasDTD = false;
            String dtd = UtilProperties.getSplitPropertyValue(UtilURL.fromResource("localdtds.properties"), publicId);
            if (Debug.verboseOn()) {
                Debug.logVerbose("[UtilXml.LocalResolver.resolveEntity] resolving DTD with publicId [" + publicId + "], systemId [" + systemId + "] and the dtd file is [" + dtd + "]", module);
            }
            if (dtd != null && dtd.length() > 0) {
                try {
                    URL dtdURL = UtilURL.fromResource(dtd);
                    InputStream dtdStream = dtdURL.openStream();
                    InputSource inputSource = new InputSource(dtdStream);
                    inputSource.setPublicId(publicId);
                    this.hasDTD = true;
                    if (Debug.verboseOn()) {
                        Debug.logVerbose("[UtilXml.LocalResolver.resolveEntity] got LOCAL DTD input source with publicId [" + publicId + "] and the dtd file is [" + dtd + "]", module);
                    }
                    return inputSource;
                }
                catch (Exception e) {
                    Debug.logWarning(e, module);
                }
            }
            if (Debug.verboseOn()) {
                Debug.logVerbose("[UtilXml.LocalResolver.resolveEntity] local resolve failed for DTD with publicId [" + publicId + "] and the dtd file is [" + dtd + "], trying defaultResolver", module);
            }
            return this.defaultResolver.resolveEntity(publicId, systemId);
        }

        public boolean hasDTD() {
            return this.hasDTD;
        }
    }
}

