/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshClassManager;
import bsh.CallStack;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.ParseException;
import bsh.Parser;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;
import bsh.TargetError;
import bsh.This;
import bsh.TokenMgrError;
import com.ibm.bsf.BSFDeclaredBean;
import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.BSFEngineImpl;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;

public class OfbizBshBsfEngine
extends BSFEngineImpl {
    protected static Map masterClassManagers = new HashMap();
    protected Interpreter interpreter;
    protected boolean installedApplyMethod;
    public static UtilCache parsedScripts = new UtilCache("webapp.BshBsfParsedCache", 0L, 0L, false);
    static final String bsfApplyMethod = "_bsfApply(_bsfNames, _bsfArgs, _bsfText) {for(i=0;i<_bsfNames.length;i++)this.namespace.setVariable(_bsfNames[i], _bsfArgs[i]);return this.interpreter.eval(_bsfText, this.namespace);}";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void initialize(BSFManager mgr, String lang, Vector declaredBeans) throws BSFException {
        super.initialize(mgr, lang, declaredBeans);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        BshClassManager master = (BshClassManager)masterClassManagers.get(classLoader);
        if (master == null) {
            Class<OfbizBshBsfEngine> clazz = OfbizBshBsfEngine.class;
            // MONITORENTER : bsh.OfbizBshBsfEngine.class
            master = (BshClassManager)masterClassManagers.get(classLoader);
            if (master == null) {
                master = BshClassManager.createClassManager();
                master.setClassLoader(classLoader);
                masterClassManagers.put(classLoader, master);
            }
            // MONITOREXIT : clazz
        }
        if (master != null) {
            this.interpreter = new Interpreter((Reader)new StringReader(""), System.out, System.err, false, new NameSpace(master, "global"), null, null);
        } else {
            this.interpreter = new Interpreter();
            this.interpreter.setClassLoader(classLoader);
        }
        try {
            this.interpreter.set("bsf", (Object)mgr);
        }
        catch (EvalError e) {
            throw new BSFException("bsh internal error: " + e.toString());
        }
        int i = 0;
        while (i < declaredBeans.size()) {
            BSFDeclaredBean bean = (BSFDeclaredBean)declaredBeans.get(i);
            this.declareBean(bean);
            ++i;
        }
    }

    public void setDebug(boolean debug) {
        Interpreter.DEBUG = debug;
    }

    public Object call(Object object, String name, Object[] args) throws BSFException {
        if (object == null) {
            try {
                object = this.interpreter.get("global");
            }
            catch (EvalError e) {
                throw new BSFException("bsh internal error: " + e.toString());
            }
        }
        if (object instanceof This) {
            try {
                return ((This)object).invokeMethod(name, args);
            }
            catch (InterpreterError e) {
                throw new BSFException("BeanShell interpreter internal error: " + (Object)((Object)e));
            }
            catch (TargetError e2) {
                throw new BSFException("The application script threw an exception: " + e2.getTarget());
            }
            catch (EvalError e3) {
                throw new BSFException("BeanShell script error: " + (Object)((Object)e3));
            }
        }
        throw new BSFException("Cannot invoke method: " + name + ". Object: " + object + " is not a BeanShell scripted object.");
    }

    public Object apply(String source, int lineNo, int columnNo, Object funcBody, Vector namesVec, Vector argsVec) throws BSFException {
        if (namesVec.size() != argsVec.size()) {
            throw new BSFException("number of params/names mismatch");
        }
        if (!(funcBody instanceof String)) {
            throw new BSFException("apply: function body must be a string");
        }
        Object[] names = new String[namesVec.size()];
        namesVec.copyInto(names);
        Object[] args = new String[argsVec.size()];
        argsVec.copyInto(args);
        try {
            if (!this.installedApplyMethod) {
                this.interpreter.eval(bsfApplyMethod);
                this.installedApplyMethod = true;
            }
            This global = (This)this.interpreter.get("global");
            return global.invokeMethod("_bsfApply", new Object[]{names, args, (String)funcBody});
        }
        catch (InterpreterError e) {
            throw new BSFException("BeanShell interpreter internal error: " + (Object)((Object)e) + this.sourceInfo(source, lineNo, columnNo));
        }
        catch (TargetError e2) {
            throw new BSFException("The application script threw an exception: " + e2.getTarget() + this.sourceInfo(source, lineNo, columnNo));
        }
        catch (EvalError e3) {
            throw new BSFException("BeanShell script error: " + (Object)((Object)e3) + this.sourceInfo(source, lineNo, columnNo));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object eval(String source, int lineNo, int columnNo, Object expr) throws BSFException {
        if (!(expr instanceof String)) {
            throw new BSFException("BeanShell expression must be a string");
        }
        try {
            List parsedLineNodes = null;
            if (source != null && source.length() > 0) {
                parsedLineNodes = (List)parsedScripts.get(source);
                if (parsedLineNodes == null) {
                    Class<OfbizBshBsfEngine> clazz = OfbizBshBsfEngine.class;
                    synchronized (OfbizBshBsfEngine.class) {
                        parsedLineNodes = (List)parsedScripts.get(source);
                        if (parsedLineNodes == null) {
                            parsedLineNodes = this.bshParse(source, new StringReader((String)expr));
                            Debug.logInfo("Caching BSH script at: " + source);
                            parsedScripts.put(source, parsedLineNodes);
                        }
                        // ** MonitorExit[var6_9] (shouldn't be in output)
                    }
                }
            } else {
                parsedLineNodes = this.bshParse(source, new StringReader((String)expr));
            }
            return this.bshEval(source, parsedLineNodes, this.interpreter);
        }
        catch (InterpreterError e) {
            throw new BSFException("BeanShell interpreter internal error: " + (Object)((Object)e) + this.sourceInfo(source, lineNo, columnNo));
        }
        catch (TargetError e2) {
            throw new BSFException("The application script threw an exception: " + e2.getTarget() + " " + this.sourceInfo(source, lineNo, columnNo));
        }
        catch (EvalError e3) {
            throw new BSFException("BeanShell script error: " + (Object)((Object)e3) + this.sourceInfo(source, lineNo, columnNo));
        }
    }

    public void exec(String source, int lineNo, int columnNo, Object script) throws BSFException {
        this.eval(source, lineNo, columnNo, script);
    }

    public void declareBean(BSFDeclaredBean bean) throws BSFException {
        try {
            this.interpreter.set(bean.name, bean.bean);
        }
        catch (EvalError e) {
            throw new BSFException("error declaring bean: " + bean.name + " : " + e.toString());
        }
    }

    public void undeclareBean(BSFDeclaredBean bean) throws BSFException {
        try {
            this.interpreter.unset(bean.name);
        }
        catch (EvalError e) {
            throw new BSFException("bsh internal error: " + e.toString());
        }
    }

    public void terminate() {
    }

    private String sourceInfo(String source, int lineNo, int columnNo) {
        return "BSF info: " + source + " at line: " + lineNo + " column: " + columnNo;
    }

    public List bshParse(String sourceFileInfo, Reader in) throws ParseException {
        LinkedList<SimpleNode> parsedLineNodes = new LinkedList<SimpleNode>();
        Parser parser = new Parser(in);
        boolean eof = false;
        while (!eof) {
            try {
                eof = parser.Line();
                if (parser.jjtree.nodeArity() <= 0) continue;
                SimpleNode node = (SimpleNode)parser.jjtree.rootNode();
                node.setSourceFile(sourceFileInfo);
                parsedLineNodes.add(node);
                if (!Debug.verboseOn()) continue;
                Debug.logVerbose("// " + node.getText());
            }
            catch (ParseException e) {
                e.setErrorSourceFile(sourceFileInfo);
                Debug.logError(e);
                throw e;
            }
            finally {
                parser.jjtree.reset();
            }
        }
        return parsedLineNodes;
    }

    public Object bshEval(String sourceFileInfo, List parsedLineNodes, Interpreter parentInterpreter) throws EvalError {
        if (parsedLineNodes == null) {
            return null;
        }
        NameSpace nameSpace = parentInterpreter.getNameSpace();
        Object retVal = null;
        if (Debug.verboseOn()) {
            Debug.logVerbose("eval: nameSpace = " + nameSpace);
        }
        CallStack callstack = new CallStack();
        callstack.push(nameSpace);
        for (SimpleNode node : parsedLineNodes) {
            try {
                retVal = node.eval(callstack, parentInterpreter);
                if (callstack.depth() > 1) {
                    throw new InterpreterError("Callstack growing: " + callstack);
                }
                if (!(retVal instanceof ReturnControl)) continue;
                retVal = ((ReturnControl)retVal).value;
                break;
            }
            catch (InterpreterError e) {
                Debug.logError(e);
                throw new EvalError("Sourced file: " + sourceFileInfo + " internal Error: " + e.getMessage(), node, callstack);
            }
            catch (TargetError e) {
                if (e.getNode() == null) {
                    e.setNode(node);
                }
                Debug.logError(e, "Outermost exception: ");
                Debug.logError(e.getTarget(), "BSH Target Exception: ");
                e.reThrow("Sourced file: " + sourceFileInfo);
            }
            catch (EvalError e) {
                if (e.getNode() == null) {
                    e.setNode(node);
                }
                Debug.logError(e);
                e.reThrow("Sourced file: " + sourceFileInfo);
            }
            catch (Exception e) {
                Debug.logError(e);
                EvalError newError = new EvalError("Sourced file: " + sourceFileInfo + " unknown error: " + e.getMessage(), node, callstack);
                Debug.logError(newError);
                throw newError;
            }
            catch (TokenMgrError e) {
                Debug.logError(e);
                EvalError newError = new EvalError("Sourced file: " + sourceFileInfo + " Token Parsing Error: " + e.getMessage(), node, callstack);
                Debug.logError(newError);
                throw newError;
            }
            finally {
                if (callstack.depth() <= 1) continue;
                callstack.clear();
                callstack.push(nameSpace);
            }
        }
        return Primitive.unwrap(retVal);
    }
}

