/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.tags.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.jsp.jstl.sql.SQLExecutionTag;
import javax.sql.DataSource;
import org.apache.commons.jelly.JellyTagException;
import org.apache.commons.jelly.TagSupport;
import org.apache.commons.jelly.tags.Resources;
import org.apache.commons.jelly.tags.sql.DataSourceUtil;
import org.apache.commons.jelly.tags.sql.TransactionTag;

public abstract class SqlTagSupport
extends TagSupport
implements SQLExecutionTag {
    protected String var;
    protected String scope = "page";
    protected Object rawDataSource;
    protected boolean dataSourceSpecified;
    protected String sql;
    private List parameters;
    protected boolean isPartOfTransaction;
    static /* synthetic */ Class class$org$apache$commons$jelly$tags$sql$TransactionTag;

    public void setVar(String var) {
        this.var = var;
    }

    public void setScope(String scopeName) {
        this.scope = scopeName;
    }

    public void setDataSource(Object dataSource) {
        this.rawDataSource = dataSource;
        this.dataSourceSpecified = true;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public void addSQLParameter(Object o) {
        if (this.parameters == null) {
            this.parameters = new ArrayList();
        }
        this.parameters.add(o);
    }

    protected boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    protected void clearParameters() {
        this.parameters = null;
    }

    protected Connection getConnection() throws JellyTagException, SQLException {
        Connection conn = null;
        this.isPartOfTransaction = false;
        TransactionTag parent = (TransactionTag)this.findAncestorWithClass(class$org$apache$commons$jelly$tags$sql$TransactionTag == null ? (class$org$apache$commons$jelly$tags$sql$TransactionTag = SqlTagSupport.class$("org.apache.commons.jelly.tags.sql.TransactionTag")) : class$org$apache$commons$jelly$tags$sql$TransactionTag);
        if (parent != null) {
            if (this.dataSourceSpecified) {
                throw new JellyTagException(Resources.getMessage((String)"ERROR_NESTED_DATASOURCE"));
            }
            conn = parent.getSharedConnection();
            this.isPartOfTransaction = true;
        } else {
            if (this.rawDataSource == null && this.dataSourceSpecified) {
                throw new JellyTagException(Resources.getMessage((String)"SQL_DATASOURCE_NULL"));
            }
            DataSource dataSource = DataSourceUtil.getDataSource(this.rawDataSource, this.context);
            try {
                conn = dataSource.getConnection();
            }
            catch (Exception ex) {
                throw new JellyTagException(Resources.getMessage((String)"DATASOURCE_INVALID", (Object)ex.getMessage()));
            }
        }
        return conn;
    }

    protected void setParameters(PreparedStatement ps) throws SQLException {
        if (this.parameters != null) {
            int i = 0;
            while (i < this.parameters.size()) {
                ps.setObject(i + 1, this.parameters.get(i));
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

