/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys;

import java.io.PrintStream;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.MgmtData;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.utils.SignatureElementProxy;

public class KeyUtils {
    private KeyUtils() {
    }

    public static void prinoutKeyInfo(KeyInfo keyInfo, PrintStream printStream) throws NoSuchAlgorithmException, InvalidKeySpecException, XMLSecurityException {
        SignatureElementProxy signatureElementProxy;
        int n;
        for (n = 0; n < keyInfo.lengthKeyName(); ++n) {
            signatureElementProxy = keyInfo.itemKeyName(n);
            printStream.println("KeyName(" + n + ")=\"" + ((KeyName)signatureElementProxy).getKeyName() + "\"");
        }
        for (n = 0; n < keyInfo.lengthKeyValue(); ++n) {
            signatureElementProxy = keyInfo.itemKeyValue(n);
            PublicKey publicKey = ((KeyValue)signatureElementProxy).getPublicKey();
            printStream.println("KeyValue Nr. " + n);
            printStream.println(publicKey);
        }
        for (n = 0; n < keyInfo.lengthMgmtData(); ++n) {
            signatureElementProxy = keyInfo.itemMgmtData(n);
            printStream.println("MgmtData(" + n + ")=\"" + ((MgmtData)signatureElementProxy).getMgmtData() + "\"");
        }
        for (n = 0; n < keyInfo.lengthX509Data(); ++n) {
            signatureElementProxy = keyInfo.itemX509Data(n);
            printStream.println("X509Data(" + n + ")=\"" + (((X509Data)signatureElementProxy).containsCertificate() ? "Certificate " : "") + (((X509Data)signatureElementProxy).containsIssuerSerial() ? "IssuerSerial " : "") + "\"");
        }
    }
}

