/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.XADataSource;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.TransactionFactory;
import org.ofbiz.core.util.Debug;
import org.w3c.dom.Element;

public class JotmConnectionFactory {
    public static final String module = JotmConnectionFactory.class.getName();
    protected static Map dsCache = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String helperName, Element jotmJdbcElement) throws SQLException, GenericEntityException {
        StandardXAPoolDataSource pds = (StandardXAPoolDataSource)dsCache.get(helperName);
        if (pds != null) {
            if (Debug.verboseOn()) {
                Debug.logInfo((String)(helperName + " pool size: " + pds.pool.getCount()), (String)module);
            }
            return pds.getConnection();
        }
        Class<JotmConnectionFactory> clazz = JotmConnectionFactory.class;
        synchronized (JotmConnectionFactory.class) {
            StandardXADataSource ds;
            pds = (StandardXAPoolDataSource)dsCache.get(helperName);
            if (pds != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return pds.getConnection();
            }
            try {
                ds = new StandardXADataSource();
                pds = new StandardXAPoolDataSource();
            }
            catch (NoClassDefFoundError e) {
                throw new GenericEntityException("Cannot find enhydra-jdbc.jar");
            }
            ds.setDriverName(jotmJdbcElement.getAttribute("jdbc-driver"));
            ds.setUrl(jotmJdbcElement.getAttribute("jdbc-uri"));
            ds.setUser(jotmJdbcElement.getAttribute("jdbc-username"));
            ds.setPassword(jotmJdbcElement.getAttribute("jdbc-password"));
            ds.setDescription(helperName);
            ds.setTransactionManager(TransactionFactory.getTransactionManager());
            String transIso = jotmJdbcElement.getAttribute("isolation-level");
            if (transIso != null && transIso.length() > 0) {
                if ("Serializable".equals(transIso)) {
                    ds.setTransactionIsolation(8);
                } else if ("RepeatableRead".equals(transIso)) {
                    ds.setTransactionIsolation(4);
                } else if ("ReadUncommitted".equals(transIso)) {
                    ds.setTransactionIsolation(1);
                } else if ("ReadCommitted".equals(transIso)) {
                    ds.setTransactionIsolation(2);
                } else if ("None".equals(transIso)) {
                    ds.setTransactionIsolation(0);
                }
            }
            pds.setDataSource((XADataSource)ds);
            pds.setDescription(ds.getDescription());
            pds.setUser(ds.getUser());
            pds.setPassword(ds.getPassword());
            pds.setTransactionManager(TransactionFactory.getTransactionManager());
            try {
                pds.setMaxSize(new Integer(jotmJdbcElement.getAttribute("pool-maxsize")).intValue());
                pds.setMinSize(new Integer(jotmJdbcElement.getAttribute("pool-minsize")).intValue());
                pds.setSleepTime(new Long(jotmJdbcElement.getAttribute("pool-sleeptime")).longValue());
                pds.setLifeTime(new Long(jotmJdbcElement.getAttribute("pool-lifetime")).longValue());
                pds.setDeadLockMaxWait(new Long(jotmJdbcElement.getAttribute("pool-deadlock-maxwait")).longValue());
                pds.setDeadLockRetryWait(new Long(jotmJdbcElement.getAttribute("pool-deadlock-retrywait")).longValue());
            }
            catch (NumberFormatException nfe) {
                Debug.logError((Throwable)nfe, (String)"Problems with pool settings; the values MUST be numbers, using defaults.", (String)module);
            }
            catch (Exception e) {
                Debug.logError((Throwable)e, (String)"Problems with pool settings", (String)module);
            }
            dsCache.put(helperName, pds);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return pds.getConnection();
        }
    }
}

