<%@ page import="org.apache.lucene.document.Document,
                 java.util.Enumeration,
                 org.apache.lucene.document.Field,
                 org.apache.lucene.index.IndexReader,
                 java.io.IOException,
				 java.net.URLEncoder,
                 com.opensymphony.util.TextUtils,
                 com.atlassian.jira.issue.index.DocumentConstants" %>

<%

	IndexReader reader = null;
    String indexDir = null;

	if (session.getAttribute("index.dir") != null)
	{
		indexDir = (String)session.getAttribute("index.dir");

		try
		{
			reader = IndexReader.open(indexDir);
		}
		catch (IOException e)
		{
			out.println("<b>Error</b>: Could not open index: " + e);
		}
	}

	int documentNumber = Integer.parseInt(request.getParameter("doc"));
%>

<html>

	<head>

		<title><webwork:text name="'admin.viewdocument.view.document'"/></title>

	</head>

	<body>



	<% if (reader != null) { %>



	<b><webwork:text name="'admin.viewdocument.index'"/></b>: <a href="indexbrowser.jsp?index.dir=<%= URLEncoder.encode(indexDir) %>"><%= indexDir %></a><br>

	<b><webwork:text name="'admin.indexbrowser.index.location'"/></b>: <%= indexDir %><br>

	<b><webwork:text name="'admin.indexbrowser.number.of.documents'"/></b>: <%= reader.numDocs() %><br>



	<%

		Document doc = reader.document(documentNumber);

	%>

		<p>

		<b><a href="<%= request.getContextPath() %>/secure/ViewIssue.jspa?id=<%= doc.get(DocumentConstants.ISSUE_ID) %>"><%= doc.get(DocumentConstants.ISSUE_KEY) %></a></b>



        <table cellspacing=0 cellpadding=0 border=0 bgcolor=#cccccc><tr><td>
		<table cellpadding=2 cellspacing=1 border=0>
			<tr>

				<td valign=top><font face="Verdana" size=-2><b><webwork:text name="'common.words.name'"/></b></td>

				<td valign=top><font face="Verdana" size=-2><b><webwork:text name="'admin.viewdocument.indexed'"/></b></td>

				<td valign=top><font face="Verdana" size=-2><b><webwork:text name="'admin.viewdocument.stored'"/></b></td>

				<td valign=top><font face="Verdana" size=-2><b><webwork:text name="'admin.viewdocument.tokenized'"/></b></td>

				<td valign=top><font face="Verdana" size=-2><b><webwork:text name="'admin.viewdocument.content'"/></b></td>

			</tr>

			<%

				Enumeration fields = doc.fields();



				while (fields.hasMoreElements())

				{

					Field f = (Field) fields.nextElement();

			%>

				<tr bgcolor=#ffffff>

				<td valign=top><font face="Verdana" size=-2><b><%= f.name() %></b></td>

				<td valign=top><font face="Verdana" size=-2><b><%= f.isIndexed() %></b></td>

				<td valign=top><font face="Verdana" size=-2><b><%= f.isStored() %></b></td>

				<td valign=top><font face="Verdana" size=-2><b><%= f.isTokenized() %></b></td>

				<td valign=top><font face="Verdana" size=-2>

					<%= TextUtils.htmlEncode(f.stringValue()) %>

				</td>

				</tr>

			<%

				}

			%>

		</table>

        </td></tr></table>

		</p>

	<% } %>



</body>

</html>
