<%@ taglib uri="webwork" prefix="webwork" %>
<%@ taglib uri="webwork" prefix="ui" %>
<%@ taglib uri="sitemesh-page" prefix="page" %>

<html>
<head>
	<title><webwork:text name="'admin.globalsettings.lookandfeel.edit.look.and.feel.configuration'"/></title>
</head>

<body>
<dl style="display:none;" id="jira.webresource.flushcounter"><webwork:property value="/lookAndFeelVersionNumber"/></dl>

<page:applyDecorator name="jiraform">
	<page:param name="action">EditLookAndFeel.jspa</page:param>
	<page:param name="submitId">edit_look_and_feel</page:param>
	<page:param name="submitName"><webwork:text name="'common.forms.update'"/></page:param>
	<page:param name="cancelURI">ViewLookAndFeel.jspa</page:param>
	<page:param name="title"><webwork:text name="'admin.globalsettings.lookandfeel.logo'"/></page:param>
	<page:param name="buttons">&nbsp;<input type="button" value="<webwork:text name="'admin.common.words.reset.defaults'"/>" onclick="location.href='EditLookAndFeel!reset.jspa?atl_token=' + window.atl_token()">&nbsp;</page:param>

	<ui:textfield label="text('admin.globalsettings.lookandfeel.logo.url')" name="'logoUrl'">
		<ui:param name="'size'">40</ui:param>
		<ui:param name="'description'">
			<webwork:text name="'admin.globalsettings.lookandfeel.logo.description'"/>
		</ui:param>
	</ui:textfield>

	<ui:textfield label="text('admin.globalsettings.lookandfeel.logo.width')" name="'logoWidth'">
        <ui:param name="'size'">40</ui:param>
		<ui:param name="'description'">
			<webwork:text name="'admin.globalsettings.lookandfeel.logo.width.description'"/>
		</ui:param>
	</ui:textfield>

	<ui:textfield label="text('admin.globalsettings.lookandfeel.logo.height')" name="'logoHeight'">
        <ui:param name="'size'">40</ui:param>
		<ui:param name="'description'">
			<webwork:text name="'admin.globalsettings.lookandfeel.logo.height.description'"/>
		</ui:param>
	</ui:textfield>

	<tr>
		<td align="right" bgcolor="#fffff0">&nbsp;</td>
		<td bgcolor="#ffffff">&nbsp;</td>
	</tr>


	<tr>
		<td colspan="2" bgcolor="#f0f0f0"><h3 class="formtitle"><webwork:text name="'admin.globalsettings.lookandfeel.colours'"/></h3></td>
	</tr>

    <!-- =========== MENU BAR =================== -->
	<ui:component label="text('admin.globalsettings.lookandfeel.top.bar.colour')" name="'topBgColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

    <ui:component label="text('admin.globalsettings.lookandfeel.top.bar.hilightcolour')" name="'topHighlightBgColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

    <ui:component label="text('admin.globalsettings.lookandfeel.top.text.colour')" name="'topTextColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

    <ui:component label="text('admin.globalsettings.lookandfeel.top.text.hilightcolour')" name="'topTextHighlightColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

    <ui:component label="text('admin.globalsettings.lookandfeel.top.separatorcolor')" name="'topSeparatorColor'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

    <!-- =========== MENU BAR =================== -->
	<ui:component label="text('admin.globalsettings.lookandfeel.menu.bar.colour')" name="'menuBgColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

	<ui:component label="text('admin.globalsettings.lookandfeel.menu.bar.text.colour')" name="'menuTextColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

	<ui:component label="text('admin.globalsettings.lookandfeel.menu.bar.separator.colour')" name="'menuSeparatorColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

    <!-- =========== TEXT / LINK / HEADINGS =================== -->
    <ui:component label="text('admin.globalsettings.lookandfeel.link.colour')" name="'linkColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

    <ui:component label="text('admin.globalsettings.lookandfeel.link.active.colour')" name="'linkAColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>

    <ui:component label="text('admin.globalsettings.lookandfeel.heading.colour')" name="'headingColour'" template="colorpicker.jsp">
        <ui:param name="'size'">40</ui:param>
    </ui:component>



    <tr>
		<td align="right" bgcolor="#fffff0">&nbsp;</td>
		<td bgcolor="#ffffff">&nbsp;</td>
	</tr>


    <tr>
		<td colspan="2" bgcolor="#f0f0f0"><h3 class="formtitle"><webwork:text name="'admin.globalsettings.lookandfeel.gadget.chrome.colors'"/></h3></td>
	</tr>

    <webwork:iterator value="/gadgetColors" status="'status'">
        <ui:component label="text('admin.globalsettings.lookandfeel.gadget.colour.' + .)" name="'gadgetChromeColor' + ." value="/gadgetColor(.)" template="colorpicker.jsp">
            <ui:param name="'size'">40</ui:param>
        </ui:component>
    </webwork:iterator>

    <tr>
		<td align="right" bgcolor="#fffff0">&nbsp;</td>
		<td bgcolor="#ffffff">&nbsp;</td>
	</tr>

	<tr>
		<td colspan="2" bgcolor="#f0f0f0"><h3 class="formtitle"><webwork:text name="'admin.globalsettings.lookandfeel.date.time.formats'"/></h3>
        <webwork:text name="'admin.globalsettings.lookandfeel.documentation.for.date.time'">
            <webwork:param name="'value0'"><a href="http://java.sun.com/j2se/1.4.2/docs/api/java/text/SimpleDateFormat.html"></webwork:param>
            <webwork:param name="'value1'"></a></webwork:param>
        </webwork:text>.
		</td>
	</tr>
	<ui:textfield label="text('admin.globalsettings.lookandfeel.time.format')" name="'formatTime'">
        <ui:param name="'size'">40</ui:param>
        <ui:param name="'description'">
            <webwork:text name="'admin.globalsettings.lookandfeel.eg'">
                <webwork:param name="value0">hh:mm a (<webwork:property value="/outlookDate/formatTime(exampleDate)" />)</webwork:param>
            </webwork:text>
        </ui:param>
	</ui:textfield>

	<ui:textfield label="text('admin.globalsettings.lookandfeel.day.format')" name="'formatDay'">
        <ui:param name="'size'">40</ui:param>
        <ui:param name="'description'">
            <webwork:text name="'admin.globalsettings.lookandfeel.eg'">
                <webwork:param name="value0">EEEE hh:mm a (<webwork:property value="/outlookDate/formatDay(exampleDate)" />)</webwork:param>
            </webwork:text>
        </ui:param>
	</ui:textfield>

	<ui:textfield label="text('admin.globalsettings.lookandfeel.complete.date.time.format')" name="'formatComplete'">
        <ui:param name="'size'">40</ui:param>
        <ui:param name="'description'">
            <webwork:text name="'admin.globalsettings.lookandfeel.eg'">
                <webwork:param name="value0">dd/MMM/yy hh:mm a (<webwork:property value="/outlookDate/formatDMYHMS(exampleDate)" />)</webwork:param>
            </webwork:text>
        </ui:param>
	</ui:textfield>

	<ui:textfield label="text('admin.globalsettings.lookandfeel.day.month.year.format')" name="'formatDMY'">
        <ui:param name="'size'">40</ui:param>
        <ui:param name="'description'">
            <webwork:text name="'admin.globalsettings.lookandfeel.eg'">
                <webwork:param name="value0">dd/MMM/yy (<webwork:property value="/outlookDate/formatDMY(exampleDate)" />)</webwork:param>
            </webwork:text>
        </ui:param>
	</ui:textfield>

	<ui:component label="text('admin.globalsettings.lookandfeel.date.picker.format')" template="label.jsp">
        <ui:param name="'description'">
            <webwork:text name="'admin.globalsettings.lookandfeel.please.edit.file'"/>
        </ui:param>
        <ui:param name="'value'">
            <webwork:text name="'admin.globalsettings.lookandfeel.not.currently.editable'"/>
        </ui:param>
	</ui:component>

	<ui:component label="text('admin.globalsettings.lookandfeel.date.time.picker.format')" template="label.jsp">
        <ui:param name="'description'">
            <webwork:text name="'admin.globalsettings.lookandfeel.please.edit.file'"/>
        </ui:param>
        <ui:param name="'value'">
            <webwork:text name="'admin.globalsettings.lookandfeel.not.currently.editable'"/>
        </ui:param>
	</ui:component>

    <ui:component name="'preview'" value="'false'" template="hidden.jsp" theme="'single'"  />

    <tr>
		<td align="right" bgcolor="#fffff0">&nbsp;</td>
		<td bgcolor="#ffffff">&nbsp;</td>
	</tr>

    <webwork:if test="/hasUserFormatsToEdit == true">
        <tr>
            <td colspan="2" bgcolor="#f0f0f0"><h3 class="formtitle"><webwork:text name="'admin.globalsettings.lookandfeel.user.formats'"/></h3></td>
        </tr>

        <webwork:iterator value="/userFormatTypes" status="'status'">
            <webwork:if test="/userFormatModuleDescriptorsForType(.)/size > 1">
                <ui:select label="/userFormatTypeName(.)" name="'user_format_for_' + ." list="/userFormatModuleDescriptorsForType(.)" listKey="'completeKey'" listValue="'/userFormatName(.)'"
                        value="/currentUserFormatForType(.)">
                </ui:select>
            </webwork:if>
        </webwork:iterator>

        <tr>
            <td align="right" bgcolor="#fffff0">&nbsp;</td>
            <td bgcolor="#ffffff">&nbsp;</td>
        </tr>
    </webwork:if>

    <tr>
		<td align="right" bgcolor="#fffff0">&nbsp;</td>
		<td bgcolor="#ffffff"><p><font size=1><webwork:text name="'admin.globalsettings.lookandfeel.set.selection.defaults'"/><br>
        <webwork:text name="'admin.globalsettings.lookandfeel.set.all.defaults'"/></font></p></td>
	</tr>


</page:applyDecorator>

</body>
</html>
