/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.velocity;

import com.atlassian.core.util.ClassLoaderUtils;
import com.atlassian.velocity.VelocityManager;
import com.opensymphony.util.TextUtils;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Category;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.exception.VelocityException;

public class DefaultVelocityManager
implements VelocityManager {
    private VelocityEngine ve;
    private static final Category log = Category.getInstance((Class)DefaultVelocityManager.class);

    public String getBody(String templateDirectory, String template, Map contextParameters) throws VelocityException {
        return this.getEncodedBody(templateDirectory, template, null, null, contextParameters);
    }

    public String getBody(String templateDirectory, String template, String baseurl, Map contextParameters) throws VelocityException {
        return this.getEncodedBody(templateDirectory, template, baseurl, null, contextParameters);
    }

    public String getEncodedBody(String templateDirectory, String template, String encoding, Map contextParameters) throws VelocityException {
        return this.getEncodedBody(templateDirectory, template, null, encoding, contextParameters);
    }

    public String getEncodedBody(String templateDirectory, String template, String baseurl, String encoding, Map contextParameters) throws VelocityException {
        return this.getEncodedBody(templateDirectory, template, baseurl, encoding, (Context)this.createVelocityContext(this.createContextParams(baseurl, contextParameters)));
    }

    public String getEncodedBody(String templateDirectory, String template, String baseurl, String encoding, Context context) throws VelocityException {
        if (template == null) {
            throw new VelocityException("Trying to send mail with no template.");
        }
        try {
            StringWriter writer = new StringWriter();
            if (encoding == null) {
                this.getVe().mergeTemplate(templateDirectory + template, context, (Writer)writer);
            } else {
                this.getVe().mergeTemplate(templateDirectory + template, encoding, context, (Writer)writer);
            }
            return writer.toString();
        }
        catch (ResourceNotFoundException e) {
            log.error((Object)("ResourceNotFoundException occurred whilst loading resource " + template));
            URL templateUrl = ClassLoaderUtils.getResource((String)(templateDirectory + template), this.getClass());
            if (templateUrl == null) {
                throw new VelocityException("Could not find template '" + templateDirectory + template + "' ensure it is in the classpath.");
            }
            return "Could not locate resource " + templateDirectory + template;
        }
        catch (MethodInvocationException mie) {
            Throwable e = mie.getWrappedThrowable();
            log.error((Object)("MethodInvocationException occurred getting message body from Velocity: " + e), e);
            return this.getErrorMessageForException((Exception)((Object)mie));
        }
        catch (Exception e) {
            log.error((Object)("Exception getting message body from Velocity: " + e), (Throwable)e);
            return this.getErrorMessageForException(e);
        }
    }

    protected Map createContextParams(String baseurl, Map contextParameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("baseurl", baseurl);
        params.put("formatter", this.getDateFormat());
        params.putAll(contextParameters);
        return params;
    }

    protected VelocityContext createVelocityContext(Map params) {
        if (params != null) {
            params.put("ctx", params);
        }
        return new VelocityContext(params){

            public Object put(String key, Object value) {
                if (key == null) {
                    return null;
                }
                return this.internalPut(key, value);
            }
        };
    }

    public String getEncodedBodyForContent(String content, String baseurl, Map contextParameters) throws VelocityException {
        if (content == null) {
            throw new VelocityException("Trying to send mail with no content.");
        }
        try {
            VelocityContext context = this.createVelocityContext(this.createContextParams(baseurl, contextParameters));
            StringWriter writer = new StringWriter();
            this.getVe().evaluate((Context)context, (Writer)writer, "getEncodedBodyFromContent", content);
            return writer.toString();
        }
        catch (Exception e) {
            log.error((Object)("Exception getting message body from Velocity: " + e), (Throwable)e);
            return this.getErrorMessageForException(e);
        }
    }

    protected String getErrorMessageForException(Exception e) {
        return "An error occurred whilst rendering this message.  Please contact the administrators, and inform them of this bug.\n\nDetails:\n-------\n" + TextUtils.htmlEncode((String)ExceptionUtils.getFullStackTrace((Throwable)e));
    }

    public DateFormat getDateFormat() {
        return new SimpleDateFormat("EEE, d MMM yyyy h:mm a");
    }

    protected synchronized VelocityEngine getVe() {
        if (this.ve == null) {
            this.ve = new VelocityEngine();
            this.initVe(this.ve);
        }
        return this.ve;
    }

    protected void initVe(VelocityEngine velocityEngine) {
        try {
            Properties props = new Properties();
            try {
                props.load(ClassLoaderUtils.getResourceAsStream((String)"velocity.properties", this.getClass()));
            }
            catch (Exception e) {
                props.put("resource.loader", "class");
                props.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
                props.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            }
            velocityEngine.init(props);
        }
        catch (Exception e) {
            log.error((Object)("Exception initialising Velocity: " + e), (Throwable)e);
        }
    }
}

