/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler;

import com.atlassian.scheduler.SchedulerConfig;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Category;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;

public class SchedulerUtil {
    private static final Category log = Category.getInstance((Class)SchedulerUtil.class);

    public void initializeAndStart(Scheduler scheduler) {
        SchedulerConfig config = new SchedulerConfig();
        try {
            Map jobs = config.getJobs();
            Iterator iterator = config.getTriggers().iterator();
            while (iterator.hasNext()) {
                Trigger trigger = (Trigger)iterator.next();
                JobDetail jobDetail = null;
                try {
                    jobDetail = (JobDetail)jobs.get(trigger.getFullJobName());
                    scheduler.scheduleJob(jobDetail, trigger);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to schedule job: " + (jobDetail != null ? jobDetail.getFullName() : "")), (Throwable)e);
                }
            }
            scheduler.start();
            log.info((Object)"The scheduler has been launched.");
        }
        catch (SchedulerException e) {
            log.error((Object)e, (Throwable)e);
        }
    }

    public void shutdownScheduler(Scheduler scheduler) {
        try {
            if (!scheduler.isShutdown()) {
                log.debug((Object)"Started shutting down scheduler.");
                scheduler.shutdown();
                log.debug((Object)"Finished shutting down scheduler.");
            }
        }
        catch (Exception e) {
            log.error((Object)e, (Throwable)e);
        }
    }
}

